/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalMiner
extends GuiMekanismTile<TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private static final ResourceLocation eject = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/eject.png");
    private static final ResourceLocation input = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/input.png");
    private static final ResourceLocation silk = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/silk.png");
    private MekanismButton startButton;
    private MekanismButton stopButton;
    private MekanismButton configButton;

    public GuiDigitalMiner(MekanismTileContainer<TileEntityDigitalMiner> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 76;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 7, 19, 77, 69, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            MekanismLang runningType = ((TileEntityDigitalMiner)this.tile).getEnergyContainer().getEnergyPerTick().greaterThan(((TileEntityDigitalMiner)this.tile).getEnergyContainer().getMaxEnergy()) ? MekanismLang.MINER_LOW_POWER : (((TileEntityDigitalMiner)this.tile).running ? MekanismLang.MINER_RUNNING : MekanismLang.IDLE);
            list.add(runningType.translate(new Object[0]));
            list.add(((TileEntityDigitalMiner)this.tile).searcher.state.getTextComponent());
            list.add(MekanismLang.MINER_TO_MINE.translate(TextUtils.format(((TileEntityDigitalMiner)this.tile).cachedToMine)));
            return list;
        }).spacing(1).clearFormat());
        this.func_230480_a_(new GuiDigitalSwitch(this, 19, 56, eject, () -> ((TileEntityDigitalMiner)this.tile).doEject, (ITextComponent)MekanismLang.AUTO_EJECT.translate(new Object[0]), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_EJECT_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.func_230480_a_(new GuiDigitalSwitch(this, 38, 56, input, () -> ((TileEntityDigitalMiner)this.tile).doPull, (ITextComponent)MekanismLang.AUTO_PULL.translate(new Object[0]), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_PULL_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.func_230480_a_(new GuiDigitalSwitch(this, 57, 56, silk, ((TileEntityDigitalMiner)this.tile)::getSilkTouch, (ITextComponent)MekanismLang.MINER_SILK.translate(new Object[0]), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SILK_TOUCH_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiUpgradeTab(this, this.tile));
        this.func_230480_a_(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityDigitalMiner)this.tile).getEnergyContainer(), 157, 39, 47));
        this.func_230480_a_(new GuiVisualsTab(this, (TileEntityDigitalMiner)this.tile));
        this.func_230480_a_(new GuiSlot(SlotType.DIGITAL, this, 64, 21).setRenderAboveSlots().validity(() -> ((TileEntityDigitalMiner)this.tile).missingStack).with(() -> ((TileEntityDigitalMiner)this.tile).missingStack.func_190926_b() ? SlotOverlay.CHECK : null).hover(this.getOnHover(() -> ((TileEntityDigitalMiner)this.tile).missingStack.func_190926_b() ? MekanismLang.MINER_WELL.translate(new Object[0]) : MekanismLang.MINER_MISSING_BLOCK.translate(new Object[0]))));
        this.func_230480_a_(new GuiEnergyTab(() -> {
            MinerEnergyContainer energyContainer = ((TileEntityDigitalMiner)this.tile).getEnergyContainer();
            FloatingLong perTick = energyContainer.getEnergyPerTick();
            ArrayList<Object> ret = new ArrayList<Object>(4);
            ret.add(MekanismLang.MINER_ENERGY_CAPACITY.translate(EnergyDisplay.of(energyContainer.getMaxEnergy())));
            ret.add(MekanismLang.NEEDED_PER_TICK.translate(EnergyDisplay.of(perTick)));
            if (perTick.greaterThan(energyContainer.getMaxEnergy())) {
                ret.add(MekanismLang.MINER_INSUFFICIENT_BUFFER.translateColored(EnumColor.RED, new Object[0]));
            }
            ret.add(MekanismLang.MINER_BUFFER_FREE.translate(EnergyDisplay.of(energyContainer.getNeeded())));
            return ret;
        }, (IGuiWrapper)this));
        int buttonStart = this.field_147009_r + 19;
        this.startButton = new TranslationButton(this, this.field_147003_i + 87, buttonStart, 61, 18, MekanismLang.BUTTON_START, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.START_BUTTON, this.tile)));
        this.func_230480_a_(this.startButton);
        this.stopButton = new TranslationButton(this, this.field_147003_i + 87, buttonStart + 17, 61, 18, MekanismLang.BUTTON_STOP, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STOP_BUTTON, this.tile)));
        this.func_230480_a_(this.stopButton);
        this.configButton = new TranslationButton(this, this.field_147003_i + 87, buttonStart + 34, 61, 18, MekanismLang.BUTTON_CONFIG, () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG, this.tile)));
        this.func_230480_a_(this.configButton);
        this.func_230480_a_(new TranslationButton(this, this.field_147003_i + 87, buttonStart + 51, 61, 18, MekanismLang.MINER_RESET, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.RESET_BUTTON, this.tile))));
        this.updateEnabledButtons();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.startButton.field_230693_o_ = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE || !((TileEntityDigitalMiner)this.tile).running;
        this.stopButton.field_230693_o_ = ((TileEntityDigitalMiner)this.tile).searcher.state != ThreadMinerSearch.State.IDLE && ((TileEntityDigitalMiner)this.tile).running;
        this.configButton.field_230693_o_ = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

