/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiSetEnergy;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater, MekanismTileContainer<TileEntityResistiveHeater>> {
    private GuiTextField energyUsageField;

    public GuiResistiveHeater(MekanismTileContainer<TileEntityResistiveHeater> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_238745_s_ += 2;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 48, 23, 80, 42, () -> Arrays.asList(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.RESISTIVE_HEATER_USAGE.translate(EnergyDisplay.of(((TileEntityResistiveHeater)this.tile).getEnergyContainer().getEnergyPerTick())))).clearFormat());
        this.func_230480_a_(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityResistiveHeater)this.tile).getEnergyContainer(), 164, 15));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiEnergyTab(((TileEntityResistiveHeater)this.tile).getEnergyContainer(), (IGuiWrapper)this));
        this.func_230480_a_(new GuiHeatTab(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
        this.energyUsageField = new GuiTextField(this, 50, 51, 76, 12);
        this.func_230480_a_(this.energyUsageField);
        this.energyUsageField.setText(this.energyUsageField.getText());
        this.energyUsageField.setMaxStringLength(7);
        this.energyUsageField.setInputValidator(InputValidator.DIGIT);
        this.energyUsageField.configureDigitalInput(this::setEnergyUsage);
        this.energyUsageField.func_230996_d_(true);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.getText().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.ENERGY_USAGE, ((TileEntityResistiveHeater)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.energyUsageField.getText()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.energyUsageField.setText("");
        }
    }
}

