/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.common.Mekanism;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;

public class BaseModelCache {
    private final Map<ResourceLocation, ModelData> modelMap = new Object2ObjectOpenHashMap();

    public void onBake(ModelBakeEvent evt) {
        this.modelMap.values().forEach(m -> m.reload(evt));
    }

    public void setup() {
        this.modelMap.values().forEach(ModelData::setup);
    }

    protected OBJModelData registerOBJ(ResourceLocation rl) {
        OBJModelData data = new OBJModelData(rl);
        this.modelMap.put(rl, data);
        return data;
    }

    protected JSONModelData registerJSON(ResourceLocation rl) {
        JSONModelData data = new JSONModelData(rl);
        this.modelMap.put(rl, data);
        return data;
    }

    public static class JSONModelData
    extends ModelData {
        private IBakedModel bakedModel;

        private JSONModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            IUnbakedModel unbaked;
            super.reload(evt);
            this.bakedModel = (IBakedModel)evt.getModelRegistry().get(this.rl);
            if (this.bakedModel == null) {
                Mekanism.logger.error("Baked model doesn't exist: {}", (Object)this.rl.toString());
                this.bakedModel = evt.getModelManager().func_174951_a();
            }
            if ((unbaked = evt.getModelLoader().func_209597_a(this.rl)) instanceof BlockModel) {
                this.model = ((BlockModel)unbaked).customData.getCustomGeometry();
            }
        }

        @Override
        protected void setup() {
            ModelLoader.addSpecialModel((ResourceLocation)this.rl);
        }

        public IBakedModel getBakedModel() {
            return this.bakedModel;
        }
    }

    public static class OBJModelData
    extends ModelData {
        private OBJModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            this.model = OBJLoader.INSTANCE.loadModel(new OBJModel.ModelSettings(this.rl, true, true, true, true, null));
        }
    }

    public static class ModelData {
        protected IModelGeometry<?> model;
        protected final ResourceLocation rl;
        private final Map<IModelConfiguration, IBakedModel> bakedMap = new Object2ObjectOpenHashMap();

        protected ModelData(ResourceLocation rl) {
            this.rl = rl;
        }

        protected void reload(ModelBakeEvent evt) {
            this.bakedMap.clear();
        }

        protected void setup() {
        }

        public IBakedModel bake(IModelConfiguration config) {
            return this.bakedMap.computeIfAbsent(config, c -> this.model.bake(c, (ModelBakery)ModelLoader.instance(), ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, ItemOverrideList.field_188022_a, this.rl));
        }

        public IModelGeometry<?> getModel() {
            return this.model;
        }
    }
}

