/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.client.sound.PlayerSound;
import mekanism.common.Mekanism;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.entity.player.PlayerEntity;

public class GeigerSound
extends PlayerSound {
    private final RadiationManager.RadiationScale scale;

    public static GeigerSound create(@Nonnull PlayerEntity player, RadiationManager.RadiationScale scale) {
        if (scale == RadiationManager.RadiationScale.NONE) {
            throw new IllegalArgumentException("Can't create a GeigerSound with a RadiationScale of NONE.");
        }
        int subtitleFrequency = scale == RadiationManager.RadiationScale.MEDIUM ? 50 : (scale == RadiationManager.RadiationScale.ELEVATED ? 40 : (scale == RadiationManager.RadiationScale.HIGH ? 30 : (scale == RadiationManager.RadiationScale.EXTREME ? 20 : 60)));
        return new GeigerSound(player, scale, subtitleFrequency);
    }

    private GeigerSound(@Nonnull PlayerEntity player, RadiationManager.RadiationScale scale, int subtitleFrequency) {
        super(player, Objects.requireNonNull(scale.getSoundEvent()), subtitleFrequency);
        this.scale = scale;
        this.setFade(1.0f, 1.0f);
    }

    @Override
    public boolean shouldPlaySound(@Nonnull PlayerEntity player) {
        return this.scale == Mekanism.radiationManager.getClientScale();
    }

    @Override
    public float func_147653_e() {
        return super.func_147653_e() * 0.05f;
    }
}

