/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;

public interface Attribute {
    default public void adjustProperties(AbstractBlock.Properties props) {
    }

    public static boolean has(Block block, Class<? extends Attribute> type) {
        return block instanceof ITypeBlock && ((ITypeBlock)block).getType().has(type);
    }

    public static <T extends Attribute> T get(Block block, Class<T> type) {
        return block instanceof ITypeBlock ? (T)((ITypeBlock)block).getType().get(type) : null;
    }

    public static boolean has(Block block1, Block block2, Class<? extends Attribute> type) {
        return Attribute.has(block1, type) && Attribute.has(block2, type);
    }

    public static Collection<Attribute> getAll(Block block) {
        return block instanceof ITypeBlock ? ((ITypeBlock)block).getType().getAll() : Lists.newArrayList();
    }

    public static <T extends Attribute> void ifHas(Block block, Class<T> type, Consumer<T> run) {
        T attribute;
        if (block instanceof ITypeBlock && (attribute = ((ITypeBlock)block).getType().get(type)) != null) {
            run.accept(attribute);
        }
    }

    @Nullable
    public static Direction getFacing(BlockState state) {
        AttributeStateFacing attr = Attribute.get(state.func_177230_c(), AttributeStateFacing.class);
        return attr == null ? null : attr.getDirection(state);
    }

    @Nullable
    public static BlockState setFacing(BlockState state, Direction facing) {
        AttributeStateFacing attr = Attribute.get(state.func_177230_c(), AttributeStateFacing.class);
        return attr == null ? null : attr.setDirection(state, facing);
    }

    public static boolean isActive(BlockState state) {
        AttributeStateActive attr = Attribute.get(state.func_177230_c(), AttributeStateActive.class);
        return attr != null && attr.isActive(state);
    }

    @Nonnull
    public static BlockState setActive(BlockState state, boolean active) {
        AttributeStateActive attr = Attribute.get(state.func_177230_c(), AttributeStateActive.class);
        return attr == null ? state : attr.setActive(state, active);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(Block block, Class<TIER> tierClass) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : (TIER)attr.getTier();
    }

    @Nullable
    public static BaseTier getBaseTier(Block block) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : attr.getTier().getBaseTier();
    }

    public static interface TileAttribute<TILE extends TileEntityMekanism>
    extends Attribute {
    }
}

