/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.function.ToIntFunction;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorldReader;

public class Attributes {
    public static final Attribute ACTIVE = new AttributeStateActive();
    public static final Attribute COMPARATOR = new AttributeComparator();
    public static final Attribute INVENTORY = new AttributeInventory();
    public static final Attribute MULTIBLOCK = new AttributeMultiblock();
    public static final Attribute REDSTONE = new AttributeRedstone();
    public static final Attribute SECURITY = new AttributeSecurity();

    private Attributes() {
    }

    public static class AttributeLight
    implements Attribute {
        private final int light;

        public AttributeLight(int light) {
            this.light = light;
        }

        @Override
        public void adjustProperties(AbstractBlock.Properties props) {
            props.func_235838_a_(state -> this.light);
        }
    }

    public static class AttributeCustomResistance
    implements Attribute {
        private final float resistance;

        public AttributeCustomResistance(float resistance) {
            this.resistance = resistance;
        }

        public float getResistance() {
            return this.resistance;
        }
    }

    public static class AttributeRedstoneEmitter<TILE extends TileEntityMekanism>
    implements Attribute.TileAttribute<TILE> {
        private final ToIntFunction<TILE> redstoneFunction;

        public AttributeRedstoneEmitter(ToIntFunction<TILE> redstoneFunction) {
            this.redstoneFunction = redstoneFunction;
        }

        public int getRedstoneLevel(TILE tile) {
            return this.redstoneFunction.applyAsInt(tile);
        }
    }

    public static class AttributeMultiblock
    implements Attribute {
        private AttributeMultiblock() {
        }
    }

    public static class AttributeMobSpawn
    implements Attribute {
        public static final AbstractBlock.IExtendedPositionPredicate<EntityType<?>> NEVER_PREDICATE = (state, reader, pos, entityType) -> false;
        public static final AttributeMobSpawn NEVER = new AttributeMobSpawn(NEVER_PREDICATE);
        public static final AttributeMobSpawn WHEN_NOT_FORMED = new AttributeMobSpawn((state, reader, pos, entityType) -> {
            TileEntityMultiblock tile = WorldUtils.getTileEntity(TileEntityMultiblock.class, reader, pos);
            if (tile != null && (reader instanceof IWorldReader && ((IWorldReader)reader).func_201670_d() ? tile.getMultiblock().isFormed() : tile.getMultiblock().isPositionInsideBounds(tile.getStructure(), pos.func_177984_a()))) {
                return false;
            }
            return state.func_224755_d(reader, pos, Direction.UP) && state.getLightValue(reader, pos) < 14;
        });
        private final AbstractBlock.IExtendedPositionPredicate<EntityType<?>> spawningPredicate;

        public AttributeMobSpawn(AbstractBlock.IExtendedPositionPredicate<EntityType<?>> spawningPredicate) {
            this.spawningPredicate = spawningPredicate;
        }

        @Override
        public void adjustProperties(AbstractBlock.Properties props) {
            props.func_235827_a_(this.spawningPredicate);
        }
    }

    public static class AttributeRedstone
    implements Attribute {
        private AttributeRedstone() {
        }
    }

    public static class AttributeComparator
    implements Attribute {
        private AttributeComparator() {
        }
    }

    public static class AttributeInventory
    implements Attribute {
        private AttributeInventory() {
        }
    }

    public static class AttributeSecurity
    implements Attribute {
        private AttributeSecurity() {
        }
    }
}

