/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidTank
extends BlockTile.BlockTileModel<TileEntityFluidTank, Machine<TileEntityFluidTank>>
implements IColoredBlock {
    public BlockFluidTank(Machine<TileEntityFluidTank> type) {
        super(type);
    }

    @Override
    protected int getTileLight(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        int ambientLight = 0;
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, world, pos);
        if (tile != null) {
            FluidStack fluid;
            if (MekanismConfig.client.enableAmbientLighting.get() && tile.lightUpdate() && tile.getActive()) {
                ambientLight = MekanismConfig.client.ambientLightingLevel.get();
            }
            if (!(fluid = tile.fluidTank.getFluid()).isEmpty()) {
                FluidAttributes fluidAttributes = fluid.getFluid().getAttributes();
                ambientLight = Math.max(ambientLight, world instanceof IBlockDisplayReader ? fluidAttributes.getLuminosity((IBlockDisplayReader)world, pos) : fluidAttributes.getLuminosity(fluid));
            }
        }
        return ambientLight;
    }

    @Override
    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, (IBlockReader)world, pos, true);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return this.genericClientActivated(player, hand, hit);
        }
        if (tile.tryWrench(state, player, hand, hit) != WrenchResult.PASS) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_225608_bj_()) {
            if (SecurityUtils.canAccess(player, tile)) {
                ItemStack stack = player.func_184586_b(hand);
                if (!stack.func_190926_b() && FluidUtils.handleTankInteraction(player, hand, stack, tile.fluidTank)) {
                    player.field_71071_by.func_70296_d();
                    return ActionResultType.SUCCESS;
                }
            } else {
                SecurityUtils.displayNoAccess(player);
                return ActionResultType.SUCCESS;
            }
        }
        return tile.openGui(player);
    }

    @Override
    public EnumColor getColor() {
        return Attribute.getBaseTier(this).getColor();
    }
}

