/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.ArrayList;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import mekanism.common.block.states.CorrectingIntegerProperty;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.states.IStateStorage;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.Contract;

public class BlockStateHelper {
    public static final BooleanProperty storageProperty = BooleanProperty.func_177716_a((String)"storage");
    public static final IntegerProperty FLUID_LOGGED = CorrectingIntegerProperty.create(BlockStateProperties.field_208198_y.func_177701_a(), 0, IStateFluidLoggable.VANILLA_FLUIDS.length);

    private BlockStateHelper() {
    }

    public static BlockState getDefaultState(@Nonnull BlockState state) {
        Block block = state.func_177230_c();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            state = ((AttributeState)attr).getDefaultState(state);
        }
        if (block instanceof IStateFluidLoggable) {
            state = (BlockState)state.func_206870_a((Property)((IStateFluidLoggable)block).getFluidLoggedProperty(), (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public static void fillBlockStateContainer(Block block, StateContainer.Builder<Block, BlockState> builder) {
        ArrayList properties = new ArrayList();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            ((AttributeState)attr).fillBlockStateContainer(block, properties);
        }
        if (block instanceof IStateStorage) {
            properties.add((Property<?>)storageProperty);
        }
        if (block instanceof IStateFluidLoggable) {
            properties.add((Property<?>)((IStateFluidLoggable)block).getFluidLoggedProperty());
        }
        if (!properties.isEmpty()) {
            builder.func_206894_a(properties.toArray(new Property[0]));
        }
    }

    public static AbstractBlock.Properties applyLightLevelAdjustments(AbstractBlock.Properties properties) {
        ToIntFunction existingLightLevelFunction = properties.field_235803_e_;
        return properties.func_235838_a_(state -> {
            int light = existingLightLevelFunction.applyAsInt(state);
            Block block = state.func_177230_c();
            if (block instanceof IStateFluidLoggable) {
                light = Math.max(light, ((IStateFluidLoggable)block).getFluid((BlockState)state).func_206886_c().getAttributes().getLuminosity());
            }
            return light;
        });
    }

    @Contract(value="_, null, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(block, state, (IWorld)context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), context.func_196000_l());
    }

    @Contract(value="_, null, _, _, _, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nullable PlayerEntity player, @Nonnull Direction face) {
        if (state == null) {
            return null;
        }
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            state = ((AttributeState)attr).getStateForPlacement(block, state, world, pos, player, face);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            FluidState fluidState = world.func_204610_c(pos);
            state = (BlockState)state.func_206870_a((Property)fluidLoggable.getFluidLoggedProperty(), (Comparable)Integer.valueOf(fluidLoggable.getSupportedFluidPropertyIndex(fluidState.func_206886_c())));
        }
        return state;
    }

    public static BlockState copyStateData(BlockState oldState, BlockState newState) {
        Block oldBlock = oldState.func_177230_c();
        Block newBlock = newState.func_177230_c();
        for (Attribute attr : Attribute.getAll(oldBlock)) {
            if (!(attr instanceof AttributeState)) continue;
            newState = ((AttributeState)attr).copyStateData(oldState, newState);
        }
        if (oldBlock instanceof IStateStorage && newBlock instanceof IStateStorage) {
            newState = (BlockState)newState.func_206870_a((Property)storageProperty, oldState.func_177229_b((Property)storageProperty));
        }
        if (oldBlock instanceof IStateFluidLoggable && newBlock instanceof IStateFluidLoggable) {
            IStateFluidLoggable oldFluidLoggable = (IStateFluidLoggable)oldBlock;
            IStateFluidLoggable newFluidLoggable = (IStateFluidLoggable)newBlock;
            if (oldFluidLoggable.getSupportedFluids().length == newFluidLoggable.getSupportedFluids().length) {
                newState = (BlockState)newState.func_206870_a((Property)newFluidLoggable.getFluidLoggedProperty(), oldState.func_177229_b((Property)oldFluidLoggable.getFluidLoggedProperty()));
            }
        }
        return newState;
    }
}

