/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import java.util.function.Consumer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class StructureBuilder {
    protected final int sizeX;
    protected final int sizeY;
    protected final int sizeZ;

    protected StructureBuilder(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    protected abstract void build(World var1, BlockPos var2);

    protected void buildFrame(World world, BlockPos start) {
        this.buildPartialFrame(world, start, -1);
    }

    protected void buildPartialFrame(World world, BlockPos start, int cutoff) {
        for (int x = 0; x < this.sizeX; ++x) {
            if (x <= cutoff || x >= this.sizeX - 1 - cutoff) continue;
            world.func_175656_a(start.func_177982_a(x, 0, 0), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(x, this.sizeY - 1, 0), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(x, 0, this.sizeZ - 1), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(x, this.sizeY - 1, this.sizeZ - 1), this.getCasing().func_176223_P());
        }
        for (int y = 0; y < this.sizeY; ++y) {
            if (y <= cutoff || y >= this.sizeY - 1 - cutoff) continue;
            world.func_175656_a(start.func_177982_a(0, y, 0), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(this.sizeX - 1, y, 0), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(0, y, this.sizeZ - 1), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(this.sizeX - 1, y, this.sizeZ - 1), this.getCasing().func_176223_P());
        }
        for (int z = 0; z < this.sizeZ; ++z) {
            if (z <= cutoff || z >= this.sizeZ - 1 - cutoff) continue;
            world.func_175656_a(start.func_177982_a(0, 0, z), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(this.sizeX - 1, 0, z), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(0, this.sizeY - 1, z), this.getCasing().func_176223_P());
            world.func_175656_a(start.func_177982_a(this.sizeX - 1, this.sizeY - 1, z), this.getCasing().func_176223_P());
        }
    }

    protected void buildWalls(World world, BlockPos start) {
        BlockPos pos;
        int z;
        for (int x = 1; x < this.sizeX - 1; ++x) {
            for (z = 1; z < this.sizeZ - 1; ++z) {
                pos = new BlockPos(x, 0, z);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getFloorBlock(pos).func_176223_P());
                pos = new BlockPos(x, this.sizeY - 1, z);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getRoofBlock(pos).func_176223_P());
            }
        }
        for (int y = 1; y < this.sizeY - 1; ++y) {
            for (int x = 1; x < this.sizeZ - 1; ++x) {
                pos = new BlockPos(x, y, 0);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getWallBlock(pos).func_176223_P());
                pos = new BlockPos(x, y, this.sizeZ - 1);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getWallBlock(pos).func_176223_P());
            }
            for (z = 1; z < this.sizeZ - 1; ++z) {
                pos = new BlockPos(0, y, z);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getWallBlock(pos).func_176223_P());
                pos = new BlockPos(this.sizeZ - 1, y, z);
                world.func_175656_a(start.func_177971_a((Vector3i)pos), this.getWallBlock(pos).func_176223_P());
            }
        }
    }

    protected void buildInteriorLayers(World world, BlockPos start, int yMin, int yMax, Block block) {
        for (int y = yMin; y <= yMax; ++y) {
            this.buildInteriorLayer(world, start, y, block);
        }
    }

    protected void buildInteriorLayer(World world, BlockPos start, int yLevel, Block block) {
        for (int x = 1; x < this.sizeX - 1; ++x) {
            for (int z = 1; z < this.sizeZ - 1; ++z) {
                world.func_175656_a(start.func_177982_a(x, yLevel, z), block.func_176223_P());
            }
        }
    }

    protected void buildPlane(World world, BlockPos start, int x1, int z1, int x2, int z2, int yLevel, Block block) {
        for (int x = x1; x < x2 - 1; ++x) {
            for (int z = z1; z < z2 - 1; ++z) {
                world.func_175656_a(start.func_177982_a(x, yLevel, z), block.func_176223_P());
            }
        }
    }

    protected void buildColumn(World world, BlockPos start, BlockPos pos, int height, Block block) {
        for (int y = 0; y < height; ++y) {
            world.func_175656_a(start.func_177971_a((Vector3i)pos).func_177982_a(0, y, 0), block.func_176223_P());
        }
    }

    protected <T extends TileEntity> void buildColumn(World world, BlockPos start, BlockPos pos, int height, Block block, Class<T> tileClass, Consumer<T> tileConsumer) {
        for (int y = 0; y < height; ++y) {
            BlockPos position = start.func_177971_a((Vector3i)pos).func_177982_a(0, y, 0);
            world.func_175656_a(position, block.func_176223_P());
            T tile = WorldUtils.getTileEntity(tileClass, (IBlockReader)world, position);
            if (tile == null) continue;
            tileConsumer.accept(tile);
        }
    }

    protected Block getWallBlock(BlockPos pos) {
        return MekanismBlocks.STRUCTURAL_GLASS.getBlock();
    }

    protected Block getFloorBlock(BlockPos pos) {
        return this.getCasing();
    }

    protected Block getRoofBlock(BlockPos pos) {
        return this.getWallBlock(pos);
    }

    protected abstract Block getCasing();
}

