/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

public class FluidTransmitterSaveTarget
extends Target<MechanicalPipe, Integer, FluidStack> {
    private FluidStack currentStored = FluidStack.EMPTY;

    public FluidTransmitterSaveTarget(@Nonnull FluidStack type) {
        this.extra = type;
    }

    @Override
    protected void acceptAmount(MechanicalPipe transmitter, SplitInfo<Integer> splitInfo, Integer amount) {
        amount = Math.min(amount, MathUtils.clampToInt(transmitter.getCapacity() - (long)this.currentStored.getAmount()));
        FluidStack newFluid = new FluidStack((FluidStack)this.extra, amount.intValue());
        if (this.currentStored.isEmpty()) {
            this.currentStored = newFluid;
        } else {
            this.currentStored.grow(amount.intValue());
        }
        splitInfo.send(amount);
    }

    @Override
    protected Integer simulate(MechanicalPipe transmitter, @Nonnull FluidStack fluidStack) {
        if (!this.currentStored.isEmpty() && !this.currentStored.isFluidEqual(fluidStack)) {
            return 0;
        }
        return Math.min(fluidStack.getAmount(), MathUtils.clampToInt(transmitter.getCapacity() - (long)this.currentStored.getAmount()));
    }

    public void saveShare(Direction handlerDirection) {
        MechanicalPipe pipe = (MechanicalPipe)this.handlers.get(handlerDirection);
        if (this.currentStored.isEmpty() != pipe.saveShare.isEmpty() || !this.currentStored.isEmpty() && !this.currentStored.isFluidStackIdentical(pipe.saveShare)) {
            pipe.saveShare = this.currentStored;
            pipe.getTransmitterTile().markDirty(false);
        }
    }
}

