/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.network.PacketTransporterUpdate;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class LogisticalTransporterBase
extends Transmitter<IItemHandler, InventoryNetwork, LogisticalTransporterBase> {
    protected final Int2ObjectMap<TransporterStack> transit = new Int2ObjectOpenHashMap();
    protected final Int2ObjectMap<TransporterStack> needsSync = new Int2ObjectOpenHashMap();
    public final TransporterTier tier;
    protected int nextId = 0;
    protected int delay = 0;
    protected int delayCount = 0;

    protected LogisticalTransporterBase(TileEntityTransmitter tile, TransporterTier tier) {
        super(tile, TransmissionType.ITEM);
        this.tier = tier;
    }

    public AcceptorCache<IItemHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    public EnumColor getColor() {
        return null;
    }

    public boolean canEmitTo(Direction side) {
        if (this.canConnect(side)) {
            ConnectionType connectionType = this.getConnectionType(side);
            return connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PUSH;
        }
        return false;
    }

    public boolean canReceiveFrom(Direction side) {
        return this.canConnect(side) && this.getConnectionType(side) == ConnectionType.NORMAL;
    }

    @Override
    public boolean isValidTransmitterBasic(TileEntityTransmitter transmitter, Direction side) {
        if (transmitter.getTransmitter() instanceof LogisticalTransporterBase) {
            LogisticalTransporterBase transporter = (LogisticalTransporterBase)transmitter.getTransmitter();
            if (this.getColor() == null || transporter.getColor() == null || this.getColor() == transporter.getColor()) {
                return super.isValidTransmitterBasic(transmitter, side);
            }
        }
        return false;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return super.isValidAcceptor(tile, side) && ((AcceptorCache)this.getAcceptorCache()).isAcceptorAndListen(tile, side, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public void tick() {
        if (this.isRemote()) {
            for (TransporterStack stack : this.transit.values()) {
                stack.progress = Math.min(100, stack.progress + this.tier.getSpeed());
            }
        } else if (this.getTransmitterNetwork() != null) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.delay = 3;
                for (Direction side : this.getConnections(ConnectionType.PULL)) {
                    TransitRequest request;
                    TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
                    if (tile == null || (request = TransitRequest.anyItem(tile, side.func_176734_d(), this.tier.getPullAmount())).isEmpty()) continue;
                    TransitRequest.TransitResponse response = this.insert(tile, request, this.getColor(), true, 0);
                    if (response.isEmpty()) {
                        ++this.delayCount;
                        this.delay = Math.min(40, (int)Math.exp(this.delayCount));
                        continue;
                    }
                    response.useAll();
                    this.delay = 10;
                }
            }
            IntOpenHashSet deletes = new IntOpenHashSet();
            for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
                boolean tryRecalculate;
                int stackId = entry.getIntKey();
                TransporterStack stack = (TransporterStack)entry.getValue();
                if (!(stack.initiatedPath || !stack.itemStack.func_190926_b() && this.recalculate(stackId, stack, null))) {
                    deletes.add(stackId);
                    continue;
                }
                stack.progress += this.tier.getSpeed();
                if (stack.progress >= 100) {
                    BlockPos prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.getPath().indexOf(this.getTilePos());
                        if (currentIndex == 0) {
                            deletes.add(stackId);
                            continue;
                        }
                        BlockPos next = stack.getPath().get(currentIndex - 1);
                        if (next != null) {
                            TileEntityLogisticalTransporterBase tile;
                            if (!stack.isFinal(this)) {
                                tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IBlockReader)this.getTileWorld(), next);
                                if (stack.canInsertToTransporter(tile, stack.getSide(this), (TileEntity)this.getTransmitterTile())) {
                                    tile.getTransmitter().entityEntering(stack, stack.progress % 100);
                                    deletes.add(stackId);
                                    continue;
                                }
                                prevSet = next;
                            } else if (stack.getPathType() != TransporterStack.Path.NONE && (tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), next)) != null) {
                                TransitRequest.TransitResponse response = TransitRequest.simple(stack.itemStack).addToInventory(tile, stack.getSide(this), stack.getPathType() == TransporterStack.Path.HOME);
                                if (!response.isEmpty()) {
                                    ItemStack rejected = response.getRejected();
                                    if (rejected.func_190926_b()) {
                                        TransporterManager.remove(this.getTileWorld(), stack);
                                        deletes.add(stackId);
                                        continue;
                                    }
                                    stack.itemStack = rejected;
                                }
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stackId, stack, prevSet)) {
                        deletes.add(stackId);
                        continue;
                    }
                    if (prevSet == null) {
                        stack.progress = 50;
                        continue;
                    }
                    stack.progress = 0;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    Direction side;
                    ConnectionType connectionType;
                    TransporterStack.Path pathType = stack.getPathType();
                    tryRecalculate = pathType == TransporterStack.Path.DEST || pathType == TransporterStack.Path.HOME ? (connectionType = this.getConnectionType(side = stack.getSide(this))) != ConnectionType.NORMAL && connectionType != ConnectionType.PUSH || !TransporterUtils.canInsert(WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), stack.getDest()), stack.color, stack.itemStack, side, pathType == TransporterStack.Path.HOME) : pathType == TransporterStack.Path.NONE;
                } else {
                    boolean bl = tryRecalculate = !stack.canInsertToTransporter(WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IBlockReader)this.getTileWorld(), stack.getNext(this)), stack.getSide(this), (TileEntity)this.getTransmitterTile());
                }
                if (!tryRecalculate || this.recalculate(stackId, stack, null)) continue;
                deletes.add(stackId);
            }
            if (!deletes.isEmpty() || !this.needsSync.isEmpty()) {
                Mekanism.packetHandler.sendToAllTracking(new PacketTransporterUpdate(this, this.needsSync, (IntSet)deletes), this.getTransmitterTile());
                deletes.forEach(this::deleteStack);
                this.needsSync.clear();
                WorldUtils.saveChunk(this.getTransmitterTile());
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (!this.isRemote() && !this.isUpgrading) {
            for (TransporterStack stack : this.getTransit()) {
                TransporterUtils.drop(this, stack);
            }
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.isRemote()) {
            for (TransporterStack stack : this.getTransit()) {
                TransporterManager.remove(this.getTileWorld(), stack);
            }
        }
    }

    @Override
    public InventoryNetwork createEmptyNetworkWithID(UUID networkID) {
        return new InventoryNetwork(networkID);
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag(CompoundNBT updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        ListNBT stacks = new ListNBT();
        for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74768_a("index", entry.getIntKey());
            ((TransporterStack)entry.getValue()).writeToUpdateTag(this, tagCompound);
            stacks.add((Object)tagCompound);
        }
        if (!stacks.isEmpty()) {
            updateTag.func_218657_a("Items", (INBT)stacks);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.transit.clear();
        if (tag.func_150297_b("Items", 9)) {
            ListNBT tagList = tag.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT compound = tagList.func_150305_b(i);
                TransporterStack stack = TransporterStack.readFromUpdate(compound);
                this.addStack(compound.func_74762_e("index"), stack);
            }
        }
    }

    @Override
    public void read(@Nonnull CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.readFromNBT(nbtTags);
    }

    protected void readFromNBT(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("Items", 9)) {
            this.readStacksFromNBT(nbtTags.func_150295_c("Items", 10));
        }
    }

    public void readStacksFromNBT(ListNBT tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            this.addStack(this.nextId++, TransporterStack.readFromNBT(tagList.func_150305_b(i)));
        }
    }

    @Override
    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT nbtTags) {
        super.write(nbtTags);
        this.writeToNBT(nbtTags);
        return nbtTags;
    }

    public void writeToNBT(CompoundNBT nbtTags) {
        ListNBT stacks = this.writeStackToNBT();
        if (!stacks.isEmpty()) {
            nbtTags.func_218657_a("Items", (INBT)stacks);
        }
    }

    public ListNBT writeStackToNBT() {
        ListNBT stacks = new ListNBT();
        for (TransporterStack stack : this.getTransit()) {
            CompoundNBT tagCompound = new CompoundNBT();
            stack.write(tagCompound);
            stacks.add((Object)tagCompound);
        }
        return stacks;
    }

    @Override
    public void takeShare() {
    }

    public double getCost() {
        return (double)TransporterTier.ULTIMATE.getSpeed() / (double)this.tier.getSpeed();
    }

    public Collection<TransporterStack> getTransit() {
        return Collections.unmodifiableCollection(this.transit.values());
    }

    public void deleteStack(int id) {
        this.transit.remove(id);
    }

    public void addStack(int id, TransporterStack s) {
        this.transit.put(id, (Object)s);
    }

    private boolean recalculate(int stackId, TransporterStack stack, BlockPos from) {
        boolean noPath;
        boolean bl = noPath = stack.getPathType() == TransporterStack.Path.NONE;
        if (!noPath) {
            noPath = stack.recalculatePath(TransitRequest.simple(stack.itemStack), this, 0).isEmpty();
        }
        if (noPath && !stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        this.needsSync.put(stackId, (Object)stack);
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    public TransitRequest.TransitResponse insert(TileEntity outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        BlockPos outputterPos = outputter.func_174877_v();
        Direction from = WorldUtils.sideDifference(this.getTilePos(), outputterPos);
        TransporterStack stack = this.insertStack(outputterPos, color);
        if (!stack.canInsertToTransporterNN(this, from, outputter)) {
            return request.getEmptyResponse();
        }
        return this.updateTransit(doEmit, stack, stack.recalculatePath(request, this, min));
    }

    public TransitRequest.TransitResponse insertRR(TileEntityLogisticalSorter outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        BlockPos outputterPos = outputter.func_174877_v();
        Direction from = WorldUtils.sideDifference(this.getTilePos(), outputterPos);
        TransporterStack stack = this.insertStack(outputterPos, color);
        if (!this.canReceiveFrom(from.func_176734_d()) || !stack.canInsertToTransporterNN(this, from, (TileEntity)outputter)) {
            return request.getEmptyResponse();
        }
        return this.updateTransit(doEmit, stack, stack.recalculateRRPath(request, outputter, this, min));
    }

    private TransporterStack insertStack(BlockPos outputterCoord, EnumColor color) {
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = outputterCoord;
        stack.homeLocation = outputterCoord;
        stack.color = color;
        return stack;
    }

    @Nonnull
    private TransitRequest.TransitResponse updateTransit(boolean doEmit, TransporterStack stack, TransitRequest.TransitResponse response) {
        if (!response.isEmpty()) {
            stack.itemStack = response.getStack();
            if (doEmit) {
                int stackId = this.nextId++;
                this.addStack(stackId, stack);
                Mekanism.packetHandler.sendToAllTracking(new PacketTransporterUpdate(this, stackId, stack), this.getTransmitterTile());
                WorldUtils.saveChunk(this.getTransmitterTile());
            }
        }
        return response;
    }

    private void entityEntering(TransporterStack stack, int progress) {
        int stackId = this.nextId++;
        stack.progress = progress;
        this.addStack(stackId, stack);
        this.needsSync.put(stackId, (Object)stack);
    }
}

