/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.hwyla;

import mcp.mobius.waila.api.IServerDataProvider;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class HwylaDataProvider
implements IServerDataProvider<TileEntity> {
    static final HwylaDataProvider INSTANCE = new HwylaDataProvider();

    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity tile) {
        if (tile instanceof TileEntityBoundingBlock) {
            TileEntityBoundingBlock boundingBlock = (TileEntityBoundingBlock)tile;
            if (!boundingBlock.receivedCoords || tile.func_174877_v().equals((Object)boundingBlock.getMainPos())) {
                return;
            }
            tile = WorldUtils.getTileEntity((IBlockReader)world, boundingBlock.getMainPos());
            if (tile == null) {
                return;
            }
        }
        HwylaLookingAtHelper helper = new HwylaLookingAtHelper();
        LookingAtUtils.addInfo(helper, tile, true, true);
        helper.finalizeData(data);
    }

    private static class HwylaLookingAtHelper
    implements LookingAtHelper {
        private final ListNBT data = new ListNBT();

        private HwylaLookingAtHelper() {
        }

        @Override
        public void addText(ITextComponent text) {
            CompoundNBT textData = new CompoundNBT();
            textData.func_74778_a("text", ITextComponent.Serializer.func_150696_a((ITextComponent)text));
            this.data.add((Object)textData);
        }

        @Override
        public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
            CompoundNBT energyData = new CompoundNBT();
            energyData.func_74778_a("energy", energy.toString());
            energyData.func_74778_a("max", maxEnergy.toString());
            this.data.add((Object)energyData);
        }

        @Override
        public void addFluidElement(FluidStack stored, int capacity) {
            CompoundNBT fluidData = new CompoundNBT();
            fluidData.func_218657_a("fluid", (INBT)stored.writeToNBT(new CompoundNBT()));
            fluidData.func_74768_a("max", capacity);
            this.data.add((Object)fluidData);
        }

        @Override
        public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
            CompoundNBT chemicalData = new CompoundNBT();
            chemicalData.func_218657_a("chemical", (INBT)stored.write(new CompoundNBT()));
            chemicalData.func_74772_a("max", capacity);
            this.data.add((Object)chemicalData);
        }

        private void finalizeData(CompoundNBT data) {
            if (!this.data.isEmpty()) {
                data.func_218657_a("mekData", (INBT)this.data);
            }
        }
    }
}

