/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import javax.annotation.Nonnull;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ArmorSlot;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.OffhandSlot;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.EnumUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ModuleTweakerContainer
extends MekanismContainer {
    public ModuleTweakerContainer(int id, PlayerInventory inv) {
        super(MekanismContainerTypes.MODULE_TWEAKER, id, inv);
        this.addSlotsAndOpen();
    }

    public ModuleTweakerContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv);
    }

    @Override
    protected void addInventorySlots(@Nonnull PlayerInventory inv) {
        int armorInventorySize = inv.field_70460_b.size();
        for (int index = 0; index < armorInventorySize; ++index) {
            EquipmentSlotType slotType = EnumUtils.EQUIPMENT_SLOT_TYPES[2 + armorInventorySize - index - 1];
            this.func_75146_a(new ArmorSlot(inv, 36 + slotType.ordinal() - 2, 8, 8 + index * 18, slotType){

                @Override
                public boolean func_82869_a(@Nonnull PlayerEntity player) {
                    return false;
                }

                @Override
                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return false;
                }
            });
        }
        for (int slotY = 0; slotY < PlayerInventory.func_70451_h(); ++slotY) {
            this.func_75146_a(new HotBarSlot((IInventory)inv, slotY, 43 + slotY * 18, 161){

                public boolean func_82869_a(@Nonnull PlayerEntity player) {
                    return false;
                }

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return false;
                }
            });
        }
        this.func_75146_a(new OffhandSlot((IInventory)inv, 40, 8, 88){

            public boolean func_82869_a(@Nonnull PlayerEntity player) {
                return false;
            }

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return false;
            }
        });
    }

    public static boolean isTweakableItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IModuleContainerItem;
    }

    public static boolean hasTweakableItem(PlayerEntity player) {
        for (int slot = 0; slot < PlayerInventory.func_70451_h(); ++slot) {
            if (!ModuleTweakerContainer.isTweakableItem((ItemStack)player.field_71071_by.field_70462_a.get(slot))) continue;
            return true;
        }
        return player.field_71071_by.field_70460_b.stream().anyMatch(ModuleTweakerContainer::isTweakableItem) || player.field_71071_by.field_184439_c.stream().anyMatch(ModuleTweakerContainer::isTweakableItem);
    }

    @Override
    public ISecurityObject getSecurityObject() {
        return ISecurityObject.NO_SECURITY;
    }
}

