/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import mekanism.api.functions.ByteSupplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.container.property.BytePropertyData;

public abstract class SyncableByte
implements ISyncableData {
    private byte lastKnownValue;

    public abstract byte get();

    public abstract void set(byte var1);

    @Override
    public ISyncableData.DirtyType isDirty() {
        byte oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public BytePropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new BytePropertyData(property, this.get());
    }

    public static SyncableByte create(final byte[] byteArray, final int idx) {
        return new SyncableByte(){

            @Override
            public byte get() {
                return byteArray[idx];
            }

            @Override
            public void set(byte value) {
                byteArray[idx] = value;
            }
        };
    }

    public static SyncableByte create(final ByteSupplier getter, final ByteConsumer setter) {
        return new SyncableByte(){

            @Override
            public byte get() {
                return getter.getAsByte();
            }

            @Override
            public void set(byte value) {
                setter.accept(value);
            }
        };
    }
}

