/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.dynamic;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.network.container.property.PropertyType;
import mekanism.common.util.LambdaMetaFactoryUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class SyncMapper {
    public static final String DEFAULT_TAG = "default";
    private static final List<SpecialPropertyHandler<?>> specialProperties = new ArrayList();
    private static final Map<Class<?>, PropertyDataClassCache> syncablePropertyMap = new Object2ObjectOpenHashMap();

    private SyncMapper() {
    }

    public static void collectScanData() {
        try {
            SyncMapper.collectScanDataUnsafe();
        }
        catch (Throwable e) {
            Mekanism.logger.error("Failed to collect scan data and create sync maps", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void collectScanDataUnsafe() throws Throwable {
        Iterator iterator;
        Object2ObjectOpenHashMap propertyMap;
        Object scanData;
        Object2ObjectOpenHashMap flatPropertyMap;
        ModList modList = ModList.get();
        Object2ObjectOpenHashMap knownClasses = new Object2ObjectOpenHashMap();
        Type containerSyncType = Type.getType(ContainerSync.class);
        Iterator iterator2 = modList.getAllScanData().iterator();
        block4: while (true) {
            if (!iterator2.hasNext()) {
                flatPropertyMap = new Object2ObjectOpenHashMap();
                scanData = knownClasses.entrySet().iterator();
                break;
            }
            scanData = (ModFileScanData)iterator2.next();
            Iterator iterator3 = scanData.getAnnotations().iterator();
            while (true) {
                if (!iterator3.hasNext()) continue block4;
                ModFileScanData.AnnotationData annotationData = (ModFileScanData.AnnotationData)iterator3.next();
                if (annotationData.getTargetType() != ElementType.FIELD || !containerSyncType.equals((Object)annotationData.getAnnotationType())) continue;
                String className = annotationData.getClassType().getClassName();
                try {
                    Class<?> annotatedClass = Class.forName(className);
                    knownClasses.computeIfAbsent(annotatedClass, clazz -> new ArrayList()).add(annotationData);
                }
                catch (ClassNotFoundException e) {
                    Mekanism.logger.error("Failed to find class '{}'", (Object)className);
                }
            }
            break;
        }
        block6: while (true) {
            if (!scanData.hasNext()) {
                propertyMap = new Object2ObjectOpenHashMap();
                iterator = flatPropertyMap.entrySet().iterator();
                break;
            }
            Map.Entry entry2 = (Map.Entry)scanData.next();
            Class clazz2 = (Class)entry2.getKey();
            ArrayList<PropertyFieldInfo> propertyInfo = new ArrayList<PropertyFieldInfo>();
            flatPropertyMap.put(clazz2, propertyInfo);
            Iterator e = ((List)entry2.getValue()).iterator();
            block7: while (true) {
                if (!e.hasNext()) continue block6;
                ModFileScanData.AnnotationData data = (ModFileScanData.AnnotationData)e.next();
                String fieldName = data.getMemberName();
                try {
                    PropertyField newField;
                    Field field = clazz2.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Map annotationData = data.getAnnotationData();
                    String getterName = annotationData.getOrDefault("getter", "");
                    SpecialPropertyHandler handler = specialProperties.stream().filter(h -> ((SpecialPropertyHandler)h).fieldType.isAssignableFrom(field.getType())).findFirst().orElse(null);
                    if (handler == null) {
                        PropertyType type = PropertyType.getFromType(field.getType());
                        String setterName = annotationData.getOrDefault("setter", "");
                        if (type != null) {
                            newField = new PropertyField(new TrackedFieldData[]{new TrackedFieldData(LambdaMetaFactoryUtil.createGetter(field, clazz2, getterName), LambdaMetaFactoryUtil.createSetter(field, clazz2, setterName), type)});
                        } else {
                            if (!field.getType().isEnum()) {
                                Mekanism.logger.error("Attempted to sync an invalid field '{}'", (Object)fieldName);
                                return;
                            }
                            newField = new PropertyField(new TrackedFieldData[]{new EnumFieldData(LambdaMetaFactoryUtil.createGetter(field, clazz2, getterName), LambdaMetaFactoryUtil.createSetter(field, clazz2, setterName), field.getType())});
                        }
                    } else {
                        newField = SyncMapper.createSpecialProperty(handler, field, clazz2, getterName);
                    }
                    String fullPath = clazz2.getName() + "#" + fieldName;
                    if (annotationData.containsKey("tags")) {
                        List tags = (List)annotationData.get("tags");
                        Iterator iterator4 = tags.iterator();
                        while (true) {
                            if (!iterator4.hasNext()) continue block7;
                            String tag = (String)iterator4.next();
                            propertyInfo.add(new PropertyFieldInfo(fullPath, tag, newField));
                        }
                    }
                    propertyInfo.add(new PropertyFieldInfo(fullPath, DEFAULT_TAG, newField));
                }
                catch (NoSuchFieldException e2) {
                    Mekanism.logger.error("Failed to find field '{}' for class '{}'", (Object)fieldName, (Object)data.getClassType());
                }
            }
            break;
        }
        while (true) {
            if (!iterator.hasNext()) break;
            Map.Entry entry3 = iterator.next();
            Class clazz3 = (Class)entry3.getKey();
            List propertyInfo = (List)entry3.getValue();
            Class current = clazz3;
            while (current.getSuperclass() != null) {
                List superInfo = (List)propertyMap.get(current = current.getSuperclass());
                if (superInfo != null) {
                    propertyInfo.addAll(superInfo);
                    break;
                }
                superInfo = (List)flatPropertyMap.get(current);
                if (superInfo == null) continue;
                propertyInfo.addAll(superInfo);
            }
            propertyMap.put(clazz3, propertyInfo);
        }
        List list = propertyMap.entrySet().stream().map(entry -> new ClassPropertyFieldInfo((Class)entry.getKey(), (List)entry.getValue())).sorted(Comparator.comparing(info -> ((ClassPropertyFieldInfo)info).className)).collect(Collectors.toList());
        Iterator iterator5 = list.iterator();
        while (iterator5.hasNext()) {
            ClassPropertyFieldInfo classPropertyInfo = (ClassPropertyFieldInfo)iterator5.next();
            PropertyDataClassCache cache = new PropertyDataClassCache();
            classPropertyInfo.propertyFields.sort(Comparator.comparing(info -> ((PropertyFieldInfo)info).fieldPath + "|" + ((PropertyFieldInfo)info).tag));
            for (PropertyFieldInfo field : classPropertyInfo.propertyFields) {
                cache.propertyFieldMap.put((Object)field.tag, (Object)field.field);
            }
            syncablePropertyMap.put(classPropertyInfo.clazz, cache);
        }
        return;
    }

    public static void setup(MekanismContainer container, Class<?> holderClass, Supplier<Object> holderSupplier) {
        SyncMapper.setup(container, holderClass, holderSupplier, DEFAULT_TAG);
    }

    public static void setup(MekanismContainer container, Class<?> holderClass, Supplier<Object> holderSupplier, String tag) {
        PropertyDataClassCache cache = syncablePropertyMap.computeIfAbsent(holderClass, SyncMapper::buildSyncMap);
        for (PropertyField field : cache.propertyFieldMap.get((Object)tag)) {
            for (TrackedFieldData data : field.trackedData) {
                container.track(data.createSyncableData(holderSupplier));
            }
        }
    }

    private static PropertyDataClassCache buildSyncMap(Class<?> clazz) {
        PropertyDataClassCache cache = new PropertyDataClassCache();
        Class<?> current = clazz;
        while (current.getSuperclass() != null) {
            PropertyDataClassCache superCache = syncablePropertyMap.get(current = current.getSuperclass());
            if (superCache == null) continue;
            cache.propertyFieldMap.putAll(superCache.propertyFieldMap);
            break;
        }
        return cache;
    }

    private static <O> PropertyField createSpecialProperty(SpecialPropertyHandler<O> handler, Field field, Class<?> objType, String getterName) throws Throwable {
        PropertyField ret = new PropertyField(new TrackedFieldData[0]);
        for (SpecialPropertyData data : ((SpecialPropertyHandler)handler).specialData) {
            Function fieldGetter = LambdaMetaFactoryUtil.createGetter(field, objType, getterName);
            TrackedFieldData trackedField = TrackedFieldData.create(data.propertyType, obj -> data.get(fieldGetter.apply(obj)), (obj, val) -> data.set(fieldGetter.apply(obj), val));
            if (trackedField == null) continue;
            ret.addTrackedData(trackedField);
        }
        return ret;
    }

    static {
        specialProperties.add(new SpecialPropertyHandler(IExtendedFluidTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(FluidStack.class, IFluidTank::getFluid, IExtendedFluidTank::setStack)}));
        specialProperties.add(new SpecialPropertyHandler(IGasTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(GasStack.class, IChemicalTank::getStack, IChemicalTank::setStack)}));
        specialProperties.add(new SpecialPropertyHandler(IInfusionTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(InfusionStack.class, IChemicalTank::getStack, IChemicalTank::setStack)}));
        specialProperties.add(new SpecialPropertyHandler(IPigmentTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(PigmentStack.class, IChemicalTank::getStack, IChemicalTank::setStack)}));
        specialProperties.add(new SpecialPropertyHandler(ISlurryTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(SlurryStack.class, IChemicalTank::getStack, IChemicalTank::setStack)}));
        specialProperties.add(new SpecialPropertyHandler(IEnergyContainer.class, new SpecialPropertyData[]{SpecialPropertyData.create(FloatingLong.class, IEnergyContainer::getEnergy, IEnergyContainer::setEnergy)}));
        specialProperties.add(new SpecialPropertyHandler(BasicHeatCapacitor.class, new SpecialPropertyData[]{SpecialPropertyData.create(Double.TYPE, BasicHeatCapacitor::getHeatCapacity, BasicHeatCapacitor::setHeatCapacityFromPacket), SpecialPropertyData.create(Double.TYPE, IHeatCapacitor::getHeat, IHeatCapacitor::setHeat)}));
        specialProperties.add(new SpecialPropertyHandler(MergedTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(FluidStack.class, obj -> obj.getFluidTank().getFluid(), (obj, val) -> obj.getFluidTank().setStack((FluidStack)val)), SpecialPropertyData.create(GasStack.class, obj -> (GasStack)obj.getGasTank().getStack(), (obj, val) -> obj.getGasTank().setStack(val)), SpecialPropertyData.create(InfusionStack.class, obj -> (InfusionStack)obj.getInfusionTank().getStack(), (obj, val) -> obj.getInfusionTank().setStack(val)), SpecialPropertyData.create(PigmentStack.class, obj -> (PigmentStack)obj.getPigmentTank().getStack(), (obj, val) -> obj.getPigmentTank().setStack(val)), SpecialPropertyData.create(SlurryStack.class, obj -> (SlurryStack)obj.getSlurryTank().getStack(), (obj, val) -> obj.getSlurryTank().setStack(val))}));
        specialProperties.add(new SpecialPropertyHandler(MergedChemicalTank.class, new SpecialPropertyData[]{SpecialPropertyData.create(GasStack.class, obj -> (GasStack)obj.getGasTank().getStack(), (obj, val) -> obj.getGasTank().setStack(val)), SpecialPropertyData.create(InfusionStack.class, obj -> (InfusionStack)obj.getInfusionTank().getStack(), (obj, val) -> obj.getInfusionTank().setStack(val)), SpecialPropertyData.create(PigmentStack.class, obj -> (PigmentStack)obj.getPigmentTank().getStack(), (obj, val) -> obj.getPigmentTank().setStack(val)), SpecialPropertyData.create(SlurryStack.class, obj -> (SlurryStack)obj.getSlurryTank().getStack(), (obj, val) -> obj.getSlurryTank().setStack(val))}));
        specialProperties.add(new SpecialPropertyHandler(VoxelCuboid.class, new SpecialPropertyData[]{SpecialPropertyData.create(BlockPos.class, VoxelCuboid::getMinPos, VoxelCuboid::setMinPos), SpecialPropertyData.create(BlockPos.class, VoxelCuboid::getMaxPos, VoxelCuboid::setMaxPos)}));
    }

    private static class PropertyFieldInfo {
        private final PropertyField field;
        private final String fieldPath;
        private final String tag;

        private PropertyFieldInfo(String fieldPath, String tag, PropertyField field) {
            this.fieldPath = fieldPath;
            this.field = field;
            this.tag = tag;
        }
    }

    private static class ClassPropertyFieldInfo {
        private final Class<?> clazz;
        private final String className;
        private final List<PropertyFieldInfo> propertyFields;

        private ClassPropertyFieldInfo(Class<?> clazz, List<PropertyFieldInfo> propertyFields) {
            this.clazz = clazz;
            this.className = clazz.getName();
            this.propertyFields = propertyFields;
        }
    }

    protected static class SpecialPropertyData<O> {
        private final Class<?> propertyType;
        private final Function<O, ?> getter;
        private final BiConsumer<O, Object> setter;

        private SpecialPropertyData(Class<?> propertyType, Function<O, ?> getter, BiConsumer<O, Object> setter) {
            this.propertyType = propertyType;
            this.getter = getter;
            this.setter = setter;
        }

        protected Object get(O obj) {
            return this.getter.apply(obj);
        }

        protected void set(O obj, Object val) {
            this.setter.accept(obj, val);
        }

        protected static <O, V> SpecialPropertyData<O> create(Class<V> propertyType, Function<O, V> getter, BiConsumer<O, V> setter) {
            return new SpecialPropertyData<O>(propertyType, getter, setter);
        }
    }

    private static class SpecialPropertyHandler<O> {
        private final Class<O> fieldType;
        private final List<SpecialPropertyData<O>> specialData = new ArrayList<SpecialPropertyData<O>>();

        @SafeVarargs
        private SpecialPropertyHandler(Class<O> fieldType, SpecialPropertyData<O> ... data) {
            this.fieldType = fieldType;
            this.specialData.addAll(Arrays.asList(data));
        }
    }

    protected static class EnumFieldData
    extends TrackedFieldData {
        private final Object[] constants;

        private EnumFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter, Class<?> enumClass) {
            super(getter, setter);
            this.constants = enumClass.getEnumConstants();
        }

        @Override
        protected ISyncableData create(Supplier<Object> getter, Consumer<Object> setter) {
            return this.createData((Enum[])this.constants, getter, setter);
        }

        protected <ENUM extends Enum<ENUM>> ISyncableData createData(ENUM[] constants, Supplier<Object> getter, Consumer<Object> setter) {
            return SyncableEnum.create(val -> constants[val], constants[0], () -> (Enum)getter.get(), setter::accept);
        }

        @Override
        protected Object getDefault() {
            return this.constants[0];
        }
    }

    protected static class TrackedFieldData {
        private PropertyType propertyType;
        private final Function<Object, Object> getter;
        private final BiConsumer<Object, Object> setter;

        protected TrackedFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        private TrackedFieldData(Function<Object, Object> getter, BiConsumer<Object, Object> setter, PropertyType propertyType) {
            this(getter, setter);
            this.propertyType = propertyType;
        }

        protected Object get(Object dataObj) {
            return this.getter.apply(dataObj);
        }

        protected void set(Object dataObj, Object value) {
            this.setter.accept(dataObj, value);
        }

        protected ISyncableData createSyncableData(Supplier<Object> obj) {
            return this.create(() -> {
                Object dataObj = obj.get();
                return dataObj == null ? this.getDefault() : this.get(dataObj);
            }, val -> {
                Object dataObj = obj.get();
                if (dataObj != null) {
                    this.set(dataObj, val);
                }
            });
        }

        protected ISyncableData create(Supplier<Object> getter, Consumer<Object> setter) {
            return this.propertyType.create(getter, setter);
        }

        protected Object getDefault() {
            return this.propertyType.getDefault();
        }

        protected static TrackedFieldData create(Class<?> propertyType, Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
            if (propertyType.isEnum()) {
                return new EnumFieldData(getter, setter, propertyType);
            }
            PropertyType type = PropertyType.getFromType(propertyType);
            if (type == null) {
                Mekanism.logger.error("Tried to create property data for invalid type '{}'.", (Object)propertyType.getName());
                return null;
            }
            return new TrackedFieldData(getter, setter, type);
        }
    }

    private static class PropertyField {
        private final List<TrackedFieldData> trackedData = new ArrayList<TrackedFieldData>();

        private PropertyField(TrackedFieldData ... data) {
            this.trackedData.addAll(Arrays.asList(data));
        }

        private void addTrackedData(TrackedFieldData data) {
            this.trackedData.add(data);
        }
    }

    private static class PropertyDataClassCache {
        private final Multimap<String, PropertyField> propertyFieldMap = LinkedHashMultimap.create();

        private PropertyDataClassCache() {
        }
    }
}

