/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRobit
extends ItemEnergized
implements IItemSustainedInventory,
ISecurityItem {
    public ItemRobit(Item.Properties properties) {
        super(() -> EntityRobit.MAX_ENERGY.multiply(0.005), () -> EntityRobit.MAX_ENERGY, properties.func_208103_a(Rarity.RARE));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)MekanismLang.ROBIT_NAME.translateColored(EnumColor.INDIGO, EnumColor.GRAY, this.getName(stack)));
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((ITextComponent)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        TileEntityMekanism chargepad = WorldUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)world, pos = context.func_195995_a());
        if (chargepad != null && !chargepad.getActive()) {
            if (!world.field_72995_K) {
                UUID ownerUUID;
                ItemStack stack = context.func_195996_i();
                EntityRobit robit = new EntityRobit(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                robit.setHome(Coord4D.get(chargepad));
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                if (energyContainer != null) {
                    robit.getEnergyContainer().setEnergy(energyContainer.getEnergy());
                }
                if ((ownerUUID = this.getOwnerUUID(stack)) == null) {
                    robit.setOwnerUUID(player.func_110124_au());
                    Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(player.func_110124_au(), null));
                } else {
                    robit.setOwnerUUID(ownerUUID);
                }
                robit.setInventory(this.getInventory(new Object[]{stack}), new Object[0]);
                robit.func_200203_b(this.getName(stack));
                robit.setSecurityMode(this.getSecurity(stack));
                world.func_217376_c((Entity)robit);
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void setName(ItemStack stack, ITextComponent name) {
        ItemDataUtils.setString(stack, "name", ITextComponent.Serializer.func_150696_a((ITextComponent)name));
    }

    public ITextComponent getName(ItemStack stack) {
        String name = ItemDataUtils.getString(stack, "name");
        return name.isEmpty() ? MekanismLang.ROBIT.translate(new Object[0]) : ITextComponent.Serializer.func_240643_a_((String)name);
    }
}

