/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;

public interface IFrequencyItem
extends IOwnerItem {
    @Override
    default public void setOwnerUUID(@Nonnull ItemStack stack, @Nullable UUID owner) {
        this.setFrequency(stack, null);
        IOwnerItem.super.setOwnerUUID(stack, owner);
    }

    default public Frequency.FrequencyIdentity getFrequency(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "frequency", 10)) {
            return Frequency.FrequencyIdentity.load(FrequencyType.TELEPORTER, ItemDataUtils.getCompound(stack, "frequency"));
        }
        return null;
    }

    default public void setFrequency(ItemStack stack, Frequency frequency) {
        if (frequency == null) {
            ItemDataUtils.removeData(stack, "frequency");
        } else {
            ItemDataUtils.setCompound(stack, "frequency", frequency.serializeIdentity());
        }
    }
}

