/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.INBTSerializable;

public class MultiblockCache<T extends MultiblockData>
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
IMekanismHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    private final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    private final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    private final List<IGasTank> gasTanks = new ArrayList<IGasTank>();
    private final List<IInfusionTank> infusionTanks = new ArrayList<IInfusionTank>();
    private final List<IPigmentTank> pigmentTanks = new ArrayList<IPigmentTank>();
    private final List<ISlurryTank> slurryTanks = new ArrayList<ISlurryTank>();
    private final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    private final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();

    public void apply(T data) {
        for (CacheSubstance type : EnumUtils.CACHE_SUBSTANCES) {
            List<? extends INBTSerializable<CompoundNBT>> containers = type.getContainerList(data);
            if (containers == null) continue;
            List<? extends INBTSerializable<CompoundNBT>> cacheContainers = type.getContainerList(this);
            for (int i = 0; i < cacheContainers.size(); ++i) {
                if (i >= containers.size()) continue;
                containers.get(i).deserializeNBT(cacheContainers.get(i).serializeNBT());
            }
        }
    }

    public void sync(T data) {
        for (CacheSubstance type : EnumUtils.CACHE_SUBSTANCES) {
            List<? extends INBTSerializable<CompoundNBT>> containersToCopy = type.getContainerList(data);
            if (containersToCopy == null) continue;
            List<? extends INBTSerializable<CompoundNBT>> cacheContainers = type.getContainerList(this);
            if (cacheContainers.isEmpty()) {
                type.prefab(this, containersToCopy.size());
            }
            for (int i = 0; i < containersToCopy.size(); ++i) {
                type.sync(cacheContainers.get(i), containersToCopy.get(i));
            }
        }
    }

    public void load(CompoundNBT nbtTags) {
        for (CacheSubstance type : EnumUtils.CACHE_SUBSTANCES) {
            type.prefab(this, nbtTags.func_74762_e(type.getTagKey() + "_stored"));
            DataHandlerUtils.readContainers(type.getContainerList(this), nbtTags.func_150295_c(type.getTagKey(), 10));
        }
    }

    public void save(CompoundNBT nbtTags) {
        for (CacheSubstance type : EnumUtils.CACHE_SUBSTANCES) {
            nbtTags.func_74768_a(type.getTagKey() + "_stored", type.getContainerList(this).size());
            nbtTags.func_218657_a(type.getTagKey(), (INBT)DataHandlerUtils.writeContainers(type.getContainerList(this)));
        }
    }

    public void merge(MultiblockCache<T> mergeCache, List<ItemStack> rejectedItems) {
        for (CacheSubstance type : EnumUtils.CACHE_SUBSTANCES) {
            type.preHandleMerge(this, mergeCache);
        }
        rejectedItems.addAll(StackUtils.getMergeRejects(this.getInventorySlots(null), mergeCache.getInventorySlots(null)));
        StackUtils.merge(this.getInventorySlots(null), mergeCache.getInventorySlots(null));
        List<IExtendedFluidTank> cacheFluidTanks = this.getFluidTanks(null);
        for (int i = 0; i < cacheFluidTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheFluidTanks.get(i), mergeCache.getFluidTanks(null).get(i));
        }
        List<IGasTank> cacheGasTanks = this.getGasTanks(null);
        for (int i = 0; i < cacheGasTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheGasTanks.get(i), mergeCache.getGasTanks(null).get(i));
        }
        List<IInfusionTank> cacheInfusionTanks = this.getInfusionTanks(null);
        for (int i = 0; i < cacheInfusionTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheInfusionTanks.get(i), mergeCache.getInfusionTanks(null).get(i));
        }
        List<IPigmentTank> cachePigmentTanks = this.getPigmentTanks(null);
        for (int i = 0; i < cachePigmentTanks.size(); ++i) {
            StorageUtils.mergeTanks(cachePigmentTanks.get(i), mergeCache.getPigmentTanks(null).get(i));
        }
        List<ISlurryTank> cacheSlurryTanks = this.getSlurryTanks(null);
        for (int i = 0; i < cacheSlurryTanks.size(); ++i) {
            StorageUtils.mergeTanks(cacheSlurryTanks.get(i), mergeCache.getSlurryTanks(null).get(i));
        }
        List<IEnergyContainer> cacheContainers = this.getEnergyContainers(null);
        for (int i = 0; i < cacheContainers.size(); ++i) {
            StorageUtils.mergeContainers(cacheContainers.get(i), mergeCache.getEnergyContainers(null).get(i));
        }
        List<IHeatCapacitor> cacheCapacitors = this.getHeatCapacitors(null);
        for (int i = 0; i < cacheCapacitors.size(); ++i) {
            StorageUtils.mergeContainers(cacheCapacitors.get(i), mergeCache.getHeatCapacitors(null).get(i));
        }
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @Nonnull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @Nonnull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }

    public static enum CacheSubstance {
        ITEMS("Items", cache -> ((MultiblockCache)cache).inventorySlots.add(BasicInventorySlot.at(cache, 0, 0)), holder -> ((IMekanismInventory)holder).getInventorySlots(null)),
        FLUID("FluidTanks", cache -> ((MultiblockCache)cache).fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, cache)), holder -> ((IMekanismFluidHandler)holder).getFluidTanks(null)),
        GAS("GasTanks", cache -> ((MultiblockCache)cache).gasTanks.add(ChemicalTankBuilder.GAS.createAllValid(Long.MAX_VALUE, (IContentsListener)cache)), holder -> ((IGasTracker)holder).getGasTanks(null)),
        INFUSION("InfusionTanks", cache -> ((MultiblockCache)cache).infusionTanks.add(ChemicalTankBuilder.INFUSION.createAllValid(Long.MAX_VALUE, (IContentsListener)cache)), holder -> ((IInfusionTracker)holder).getInfusionTanks(null)),
        PIGMENT("PigmentTanks", cache -> ((MultiblockCache)cache).pigmentTanks.add(ChemicalTankBuilder.PIGMENT.createAllValid(Long.MAX_VALUE, (IContentsListener)cache)), holder -> ((IPigmentTracker)holder).getPigmentTanks(null)),
        SLURRY("SlurryTanks", cache -> ((MultiblockCache)cache).slurryTanks.add(ChemicalTankBuilder.SLURRY.createAllValid(Long.MAX_VALUE, (IContentsListener)cache)), holder -> ((ISlurryTracker)holder).getSlurryTanks(null)),
        ENERGY("EnergyContainers", cache -> ((MultiblockCache)cache).energyContainers.add(BasicEnergyContainer.create(FloatingLong.MAX_VALUE, cache)), holder -> ((IMekanismStrictEnergyHandler)holder).getEnergyContainers(null)),
        HEAT("HeatCapacitors", cache -> ((MultiblockCache)cache).heatCapacitors.add(BasicHeatCapacitor.create(1.0, cache)), holder -> ((IMekanismHeatHandler)holder).getHeatCapacitors(null));

        private final String tagKey;
        private final Consumer<MultiblockCache<?>> defaultPrefab;
        private final Function<Object, List<? extends INBTSerializable<CompoundNBT>>> containerList;

        private CacheSubstance(String tagKey, Consumer<MultiblockCache<?>> defaultPrefab, Function<Object, List<? extends INBTSerializable<CompoundNBT>>> containerList) {
            this.tagKey = tagKey;
            this.defaultPrefab = defaultPrefab;
            this.containerList = containerList;
        }

        private void prefab(MultiblockCache<?> cache, int count) {
            for (int i = 0; i < count; ++i) {
                this.defaultPrefab.accept(cache);
            }
        }

        public List<? extends INBTSerializable<CompoundNBT>> getContainerList(Object holder) {
            return this.containerList.apply(holder);
        }

        public void sync(INBTSerializable<CompoundNBT> cache, INBTSerializable<CompoundNBT> data) {
            switch (this) {
                case ITEMS: {
                    ((IInventorySlot)cache).setStack(((IInventorySlot)data).getStack());
                    break;
                }
                case FLUID: {
                    ((IExtendedFluidTank)cache).setStack(((IExtendedFluidTank)data).getFluid());
                    break;
                }
                case GAS: {
                    ((IGasTank)cache).setStack(((IGasTank)data).getStack());
                    break;
                }
                case INFUSION: {
                    ((IInfusionTank)cache).setStack(((IInfusionTank)data).getStack());
                    break;
                }
                case PIGMENT: {
                    ((IPigmentTank)cache).setStack(((IPigmentTank)data).getStack());
                    break;
                }
                case SLURRY: {
                    ((ISlurryTank)cache).setStack(((ISlurryTank)data).getStack());
                    break;
                }
                case ENERGY: {
                    ((IEnergyContainer)cache).setEnergy(((IEnergyContainer)data).getEnergy());
                    break;
                }
                case HEAT: {
                    ((IHeatCapacitor)cache).setHeat(((IHeatCapacitor)data).getHeat());
                    if (!(cache instanceof BasicHeatCapacitor)) break;
                    ((BasicHeatCapacitor)cache).setHeatCapacity(((IHeatCapacitor)data).getHeatCapacity(), false);
                }
            }
        }

        public void preHandleMerge(MultiblockCache<?> cache, MultiblockCache<?> merge) {
            int diff = this.getContainerList(merge).size() - this.getContainerList(cache).size();
            if (diff > 0) {
                this.prefab(cache, diff);
            }
        }

        public String getTagKey() {
            return this.tagKey;
        }
    }
}

