/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.Structure;

public class StructureHelper {
    private StructureHelper() {
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds) {
        VoxelCuboid prev = null;
        for (Structure.Axis axis : Structure.Axis.AXES) {
            NavigableMap<Integer, VoxelPlane> map = structure.getMajorAxisMap(axis);
            Map.Entry<Integer, VoxelPlane> first = map.firstEntry();
            Map.Entry<Integer, VoxelPlane> last = map.lastEntry();
            if (first == null || !first.getValue().equals(last.getValue()) || !first.getValue().isFull()) {
                return null;
            }
            VoxelCuboid cuboid = VoxelCuboid.from(first.getValue(), last.getValue(), first.getKey(), last.getKey());
            if (!(prev != null || cuboid.greaterOrEqual(minBounds) && maxBounds.greaterOrEqual(cuboid))) {
                return null;
            }
            if (prev != null && !prev.equals(cuboid)) {
                return null;
            }
            prev = cuboid;
        }
        return prev;
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds, Set<VoxelCuboid.CuboidSide> sides, int tolerance) {
        if (sides.size() < 2) {
            return null;
        }
        int missing = 0;
        VoxelCuboid.CuboidBuilder builder = new VoxelCuboid.CuboidBuilder();
        for (VoxelCuboid.CuboidSide side : sides) {
            Map.Entry<Integer, VoxelPlane> entry;
            Structure.Axis axis = side.getAxis();
            Structure.Axis horizontal = axis.horizontal();
            Structure.Axis vertical = axis.vertical();
            NavigableMap<Integer, VoxelPlane> map = structure.getMajorAxisMap(axis);
            Map.Entry<Integer, VoxelPlane> entry2 = entry = side.getFace().isPositive() ? map.lastEntry() : map.firstEntry();
            if (entry == null) {
                return null;
            }
            VoxelPlane plane = entry.getValue();
            if ((missing += plane.getMissing()) > tolerance) {
                return null;
            }
            builder.set(side, entry.getKey());
            if (builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, horizontal), plane.getMinCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, horizontal), plane.getMaxCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, vertical), plane.getMinRow()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, vertical), plane.getMaxRow())) continue;
            return null;
        }
        VoxelCuboid ret = builder.build();
        if (!ret.greaterOrEqual(minBounds) || !maxBounds.greaterOrEqual(ret)) {
            return null;
        }
        return ret;
    }
}

