/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import mekanism.common.util.WorldUtils;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class Meltdown {
    private static final int DURATION = 100;
    private final World world;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final double magnitude;
    private final double chance;
    private int ticksExisted;

    public Meltdown(World world, BlockPos minPos, BlockPos maxPos, double magnitude, double chance) {
        this.world = world;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.magnitude = magnitude;
        this.chance = chance;
    }

    public boolean update() {
        int z;
        int y;
        int x;
        ++this.ticksExisted;
        if (this.world.field_73012_v.nextInt() % 10 == 0 && this.world.field_73012_v.nextDouble() < this.magnitude * this.chance && !Meltdown.createExplosion(this.world, x = this.minPos.func_177958_n() + this.world.field_73012_v.nextInt(this.maxPos.func_177958_n() - this.minPos.func_177958_n()), y = this.minPos.func_177956_o() + this.world.field_73012_v.nextInt(this.maxPos.func_177956_o() - this.minPos.func_177956_o()), z = this.minPos.func_177952_p() + this.world.field_73012_v.nextInt(this.maxPos.func_177952_p() - this.minPos.func_177952_p()), 8.0f, true, Explosion.Mode.DESTROY)) {
            this.world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
        }
        if (!WorldUtils.isBlockLoaded((IBlockReader)this.world, this.minPos) || !WorldUtils.isBlockLoaded((IBlockReader)this.world, this.maxPos)) {
            return true;
        }
        return this.ticksExisted >= 100;
    }

    private static boolean createExplosion(World worldIn, double x, double y, double z, float size, boolean causesFire, Explosion.Mode mode) {
        Explosion explosion = new Explosion(worldIn, null, null, null, x, y, z, size, causesFire, mode);
        if (ForgeEventFactory.onExplosionStart((World)worldIn, (Explosion)explosion)) {
            return false;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return true;
    }
}

