/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDropperUse {
    private final BlockPos pos;
    private final DropperAction action;
    private final TankType tankType;
    private final int tankId;

    public PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) {
        this.pos = pos;
        this.action = action;
        this.tankType = tankType;
        this.tankId = tankId;
    }

    public static void handle(PacketDropperUse message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntityMekanism tile;
            ServerPlayerEntity player = ctx.getSender();
            if (player == null || message.tankId < 0) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.pos)) != null) {
                if (tile instanceof TileEntityMultiblock) {
                    MultiblockData structure = ((TileEntityMultiblock)tile).getMultiblock();
                    if (structure.isFormed()) {
                        PacketDropperUse.handleTankType(structure, message, (PlayerEntity)player, stack, Coord4D.get(tile));
                    }
                } else {
                    PacketDropperUse.handleTankType(tile, message, (PlayerEntity)player, stack, Coord4D.get(tile));
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private static <HANDLER extends IMekanismFluidHandler & IGasTracker & IPigmentTracker> void handleTankType(HANDLER handler, PacketDropperUse message, PlayerEntity player, ItemStack stack, Coord4D coord) {
        if (message.tankType == TankType.FLUID_TANK) {
            IExtendedFluidTank fluidTank = handler.getFluidTank(message.tankId, null);
            if (fluidTank != null) {
                PacketDropperUse.handleFluidTank(player, stack, fluidTank, message.action);
            }
        } else {
            List<Object> tanks = Collections.emptyList();
            if (message.tankType == TankType.GAS_TANK) {
                tanks = ((IGasTracker)handler).getGasTanks(null);
            } else if (message.tankType == TankType.INFUSION_TANK) {
                tanks = ((IInfusionTracker)handler).getInfusionTanks(null);
            } else if (message.tankType == TankType.PIGMENT_TANK) {
                tanks = ((IPigmentTracker)handler).getPigmentTanks(null);
            } else if (message.tankType == TankType.SLURRY_TANK) {
                tanks = ((ISlurryTracker)handler).getSlurryTanks(null);
            }
            if (message.tankId < tanks.size()) {
                PacketDropperUse.handleChemicalTank(player, stack, (IChemicalTank)tanks.get(message.tankId), message.action, coord);
            }
        }
    }

    public static void encode(PacketDropperUse pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_179249_a((Enum)pkt.action);
        buf.func_179249_a((Enum)pkt.tankType);
        buf.func_150787_b(pkt.tankId);
    }

    public static PacketDropperUse decode(PacketBuffer buf) {
        return new PacketDropperUse(buf.func_179259_c(), (DropperAction)buf.func_179257_a(DropperAction.class), (TankType)buf.func_179257_a(TankType.class), buf.func_150792_a());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void handleChemicalTank(PlayerEntity player, ItemStack stack, IChemicalTank<CHEMICAL, STACK> tank, DropperAction action, Coord4D coord) {
        if (action == DropperAction.DUMP_TANK) {
            if (!tank.isEmpty()) {
                GasStack gasStack;
                if (tank instanceof IGasTank && (gasStack = (GasStack)((IGasTank)tank).getStack()).has(GasAttributes.Radiation.class)) {
                    double radioactivity = gasStack.get(GasAttributes.Radiation.class).getRadioactivity();
                    Mekanism.radiationManager.radiate(coord, radioactivity * (double)gasStack.getAmount());
                }
                tank.setEmpty();
            }
        } else {
            Object itemTank;
            IChemicalHandler handler;
            Optional cap = stack.getCapability(ChemicalUtil.getCapabilityForChemical(tank)).resolve();
            if (cap.isPresent() && (handler = (IChemicalHandler)cap.get()) instanceof IMekanismChemicalHandler && (itemTank = ((IMekanismChemicalHandler)handler).getChemicalTank(0, null)) != null) {
                if (action == DropperAction.FILL_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(tank, itemTank, player);
                } else if (action == DropperAction.DRAIN_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(itemTank, tank, player);
                }
            }
        }
    }

    private static void handleFluidTank(PlayerEntity player, ItemStack stack, IExtendedFluidTank fluidTank, DropperAction action) {
        IExtendedFluidTank itemFluidTank;
        IFluidHandlerItem fluidHandlerItem;
        if (action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            return;
        }
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler && (itemFluidTank = ((IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, player);
            } else if (action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, player);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void transferBetweenTanks(IChemicalTank<CHEMICAL, STACK> drainTank, IChemicalTank<CHEMICAL, STACK> fillTank, PlayerEntity player) {
        STACK extractedChemical;
        long amount;
        STACK chemicalInDrainTank;
        STACK simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = ((ChemicalStack)(simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL))).getAmount()) < (amount = ((ChemicalStack)chemicalInDrainTank).getAmount()) && !((ChemicalStack)(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL))).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, PlayerEntity player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    public static enum TankType {
        GAS_TANK,
        FLUID_TANK,
        INFUSION_TANK,
        PIGMENT_TANK,
        SLURRY_TANK;

    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

    }
}

