/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketPlayerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGearStateUpdate {
    private final GearType gearType;
    private final boolean state;
    private final UUID uuid;

    public PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) {
        this.gearType = gearType;
        this.uuid = uuid;
        this.state = state;
    }

    public static void handle(PacketGearStateUpdate message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (message.gearType == GearType.FLAMETHROWER) {
                Mekanism.playerState.setFlamethrowerState(message.uuid, message.state, false);
            } else if (message.gearType == GearType.JETPACK) {
                Mekanism.playerState.setJetpackState(message.uuid, message.state, false);
            } else if (message.gearType == GearType.SCUBA_MASK) {
                Mekanism.playerState.setScubaMaskState(message.uuid, message.state, false);
            } else if (message.gearType == GearType.GRAVITATIONAL_MODULATOR) {
                Mekanism.playerState.setGravitationalModulationState(message.uuid, message.state, false);
            }
            ServerPlayerEntity player = ctx.getSender();
            if (player != null) {
                Mekanism.packetHandler.sendToAllTracking(new PacketPlayerData(message.uuid), (Entity)player);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketGearStateUpdate pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.gearType);
        buf.func_179252_a(pkt.uuid);
        buf.writeBoolean(pkt.state);
    }

    public static PacketGearStateUpdate decode(PacketBuffer buf) {
        return new PacketGearStateUpdate((GearType)buf.func_179257_a(GearType.class), buf.func_179253_g(), buf.readBoolean());
    }

    public static enum GearType {
        FLAMETHROWER,
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

