/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.entity.robit.InventoryRobitContainer;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import mekanism.common.inventory.container.entity.robit.SmeltingRobitContainer;
import mekanism.common.inventory.container.item.QIOFrequencySelectItemContainer;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.inventory.container.tile.MatrixStatsTabContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.container.tile.QIOFrequencySelectTileContainer;
import mekanism.common.inventory.container.tile.UpgradeManagementContainer;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketGuiButtonPress {
    private final Type type;
    private ClickedItemButton itemButton;
    private ClickedTileButton tileButton;
    private ClickedEntityButton entityButton;
    private Hand hand;
    private int entityID;
    private int extra;
    private BlockPos tilePosition;

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile) {
        this(buttonClicked, tile.func_174877_v());
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile, int extra) {
        this(buttonClicked, tile.func_174877_v(), extra);
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGuiButtonPress(ClickedItemButton buttonClicked, Hand hand) {
        this.type = Type.ITEM;
        this.itemButton = buttonClicked;
        this.hand = hand;
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.type = Type.TILE;
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, int entityID) {
        this.type = Type.ENTITY;
        this.entityButton = buttonClicked;
        this.entityID = entityID;
    }

    public static void handle(PacketGuiButtonPress message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            INamedContainerProvider provider;
            ItemStack stack;
            ServerPlayerEntity player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (message.type == Type.ENTITY) {
                INamedContainerProvider provider2;
                Entity entity = player.field_70170_p.func_73045_a(message.entityID);
                if (entity != null && (provider2 = message.entityButton.getProvider(entity)) != null) {
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider2, buf -> buf.func_150787_b(message.entityID));
                }
            } else if (message.type == Type.TILE) {
                INamedContainerProvider provider3;
                TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.tilePosition);
                if (tile != null && (provider3 = message.tileButton.getProvider(tile, message.extra)) != null) {
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider3, buf -> {
                        buf.func_179255_a(message.tilePosition);
                        buf.func_150787_b(message.extra);
                    });
                }
            } else if (message.type == Type.ITEM && (stack = player.func_184586_b(message.hand)).func_77973_b() instanceof IGuiItem && (provider = message.itemButton.getProvider(stack, message.hand)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, buf -> {
                    buf.func_179249_a((Enum)message.hand);
                    buf.func_150788_a(stack);
                });
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketGuiButtonPress pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        if (pkt.type == Type.ENTITY) {
            buf.func_179249_a((Enum)pkt.entityButton);
            buf.func_150787_b(pkt.entityID);
        } else if (pkt.type == Type.TILE) {
            buf.func_179249_a((Enum)pkt.tileButton);
            buf.func_179255_a(pkt.tilePosition);
            buf.func_150787_b(pkt.extra);
        } else if (pkt.type == Type.ITEM) {
            buf.func_179249_a((Enum)pkt.itemButton);
            buf.func_179249_a((Enum)pkt.hand);
        }
    }

    public static PacketGuiButtonPress decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        switch (type) {
            case ENTITY: {
                return new PacketGuiButtonPress((ClickedEntityButton)buf.func_179257_a(ClickedEntityButton.class), buf.func_150792_a());
            }
            case TILE: {
                return new PacketGuiButtonPress((ClickedTileButton)buf.func_179257_a(ClickedTileButton.class), buf.func_179259_c(), buf.func_150792_a());
            }
            case ITEM: {
                return new PacketGuiButtonPress((ClickedItemButton)buf.func_179257_a(ClickedItemButton.class), (Hand)buf.func_179257_a(Hand.class));
            }
        }
        return null;
    }

    public static enum Type {
        TILE,
        ITEM,
        ENTITY;

    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_CRAFTING, (i, inv, player) -> new CraftingRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_INVENTORY(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_INVENTORY, (i, inv, player) -> new InventoryRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_MAIN(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT, (i, inv, player) -> new MainRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_REPAIR(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_REPAIR, (i, inv, player) -> new RepairRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_SMELTING(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_SMELTING, (i, inv, player) -> new SmeltingRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        });

        private final Function<Entity, INamedContainerProvider> providerFromEntity;

        private ClickedEntityButton(Function<Entity, INamedContainerProvider> providerFromEntity) {
            this.providerFromEntity = providerFromEntity;
        }

        public INamedContainerProvider getProvider(Entity entity) {
            return this.providerFromEntity.apply(entity);
        }
    }

    public static enum ClickedTileButton {
        BACK_BUTTON((tile, extra) -> {
            Block block = tile.getBlockType();
            if (Attribute.has(block, AttributeGui.class)) {
                return Attribute.get(block, AttributeGui.class).getProvider((TileEntityMekanism)tile);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((tile, extra) -> new ContainerProvider(MekanismLang.QIO_FREQUENCY_SELECT, (i, inv, player) -> new QIOFrequencySelectTileContainer(i, inv, (TileEntityMekanism)tile))),
        UPGRADE_MANAGEMENT((tile, extra) -> new ContainerProvider(MekanismLang.UPGRADES, (i, inv, player) -> new UpgradeManagementContainer(i, inv, (TileEntityMekanism)tile))),
        DIGITAL_MINER_CONFIG((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.MINER_CONFIG, (i, inv, player) -> new DigitalMinerConfigContainer(i, inv, (TileEntityDigitalMiner)tile));
            }
            return null;
        }),
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return new ContainerProvider(MekanismLang.MATRIX, (i, inv, player) -> new MekanismTileContainer<TileEntityInductionCasing>(MekanismContainerTypes.INDUCTION_MATRIX, i, inv, (TileEntityInductionCasing)tile));
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return new ContainerProvider(MekanismLang.BOILER, (i, inv, player) -> new MekanismTileContainer<TileEntityBoilerCasing>(MekanismContainerTypes.THERMOELECTRIC_BOILER, i, inv, (TileEntityBoilerCasing)tile));
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return new ContainerProvider(MekanismLang.MATRIX_STATS, (i, inv, player) -> new MatrixStatsTabContainer(i, inv, (TileEntityInductionCasing)tile));
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return new ContainerProvider(MekanismLang.BOILER_STATS, (i, inv, player) -> new EmptyTileContainer<TileEntityBoilerCasing>(MekanismContainerTypes.BOILER_STATS, i, inv, (TileEntityBoilerCasing)tile));
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }

    public static enum ClickedItemButton {
        BACK_BUTTON((stack, hand) -> {
            if (stack.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)stack.func_77973_b()).getContainerProvider((ItemStack)stack, (Hand)hand);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((stack, hand) -> new ContainerProvider(MekanismLang.QIO_FREQUENCY_SELECT, (i, inv, player) -> new QIOFrequencySelectItemContainer(i, inv, (Hand)hand, (ItemStack)stack)));

        private final BiFunction<ItemStack, Hand, INamedContainerProvider> providerFromItem;

        private ClickedItemButton(BiFunction<ItemStack, Hand, INamedContainerProvider> providerFromItem) {
            this.providerFromItem = providerFromItem;
        }

        public INamedContainerProvider getProvider(ItemStack stack, Hand hand) {
            return this.providerFromItem.apply(stack, hand);
        }
    }
}

