/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNewFilter {
    private final BlockPos pos;
    private final IFilter<?> filter;

    public PacketNewFilter(BlockPos pos, IFilter<?> filter) {
        this.pos = pos;
        this.filter = filter;
    }

    public static void handle(PacketNewFilter message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntity tile;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, message.pos)) != null) {
                if (message.filter instanceof SorterFilter && tile instanceof TileEntityLogisticalSorter) {
                    ((TileEntityLogisticalSorter)tile).getFilters().add((SorterFilter)message.filter);
                } else if (message.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                    ((TileEntityDigitalMiner)tile).getFilters().add((MinerFilter)message.filter);
                } else if (message.filter instanceof TileEntityOredictionificator.OredictionificatorFilter && tile instanceof TileEntityOredictionificator) {
                    ((TileEntityOredictionificator)tile).getFilters().add((TileEntityOredictionificator.OredictionificatorFilter)message.filter);
                } else if (message.filter instanceof QIOFilter && tile instanceof TileEntityQIOFilterHandler) {
                    ((TileEntityQIOFilterHandler)tile).getFilters().add((QIOFilter)message.filter);
                }
                tile.func_70296_d();
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketNewFilter pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        pkt.filter.write(buf);
    }

    public static PacketNewFilter decode(PacketBuffer buf) {
        return new PacketNewFilter(buf.func_179259_c(), BaseFilter.readFromPacket(buf));
    }
}

