/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.function.Supplier;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketQIOItemViewerGuiSync {
    private final Type type;
    private final Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap;
    private final long countCapacity;
    private final int typeCapacity;

    private PacketQIOItemViewerGuiSync(Type type, Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.type = type;
        this.itemMap = itemMap;
        this.countCapacity = countCapacity;
        this.typeCapacity = typeCapacity;
    }

    public static PacketQIOItemViewerGuiSync batch(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.BATCH, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync update(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync kill() {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, null, 0L, 0);
    }

    public static void handle(PacketQIOItemViewerGuiSync message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_71070_bA instanceof QIOItemViewerContainer) {
                QIOItemViewerContainer container = (QIOItemViewerContainer)player.field_71070_bA;
                switch (message.type) {
                    case BATCH: {
                        container.handleBatchUpdate(message.itemMap, message.countCapacity, message.typeCapacity);
                        break;
                    }
                    case UPDATE: {
                        container.handleUpdate(message.itemMap, message.countCapacity, message.typeCapacity);
                        break;
                    }
                    case KILL: {
                        container.handleKill();
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketQIOItemViewerGuiSync pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        if (pkt.type == Type.BATCH || pkt.type == Type.UPDATE) {
            buf.func_179254_b(pkt.countCapacity);
            buf.func_150787_b(pkt.typeCapacity);
            buf.func_150787_b(pkt.itemMap.size());
            pkt.itemMap.forEach((key, value) -> {
                buf.func_150788_a(key.getStack());
                if (key.getUUID() == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    buf.func_179252_a(key.getUUID());
                }
                buf.func_179254_b(value.longValue());
            });
        }
    }

    public static PacketQIOItemViewerGuiSync decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        long countCapacity = 0L;
        int typeCapacity = 0;
        Object2LongOpenHashMap map = null;
        if (type == Type.BATCH || type == Type.UPDATE) {
            countCapacity = buf.func_179260_f();
            typeCapacity = buf.func_150792_a();
            int count = buf.func_150792_a();
            map = new Object2LongOpenHashMap(count);
            for (int i = 0; i < count; ++i) {
                map.put((Object)new HashedItem.UUIDAwareHashedItem(buf.func_150791_c(), buf.readBoolean() ? buf.func_179253_g() : null), buf.func_179260_f());
            }
        }
        return new PacketQIOItemViewerGuiSync(type, (Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, countCapacity, typeCapacity);
    }

    public static enum Type {
        BATCH,
        UPDATE,
        KILL;

    }
}

