/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.client.MekanismClient;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSecurityUpdate {
    private final boolean isUpdate;
    private SecurityData securityData;
    private String playerUsername;
    private UUID playerUUID;
    private Map<UUID, SecurityData> securityMap = new Object2ObjectOpenHashMap();
    private Map<UUID, String> uuidMap = new Object2ObjectOpenHashMap();

    public PacketSecurityUpdate(UUID uuid, SecurityData data) {
        this(true);
        this.playerUUID = uuid;
        this.playerUsername = MekanismUtils.getLastKnownUsername(uuid);
        this.securityData = data;
    }

    public PacketSecurityUpdate() {
        this(false);
    }

    private PacketSecurityUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public static void handle(PacketSecurityUpdate message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (message.isUpdate) {
                MekanismClient.clientUUIDMap.put(message.playerUUID, message.playerUsername);
                if (message.securityData != null) {
                    MekanismClient.clientSecurityMap.put(message.playerUUID, message.securityData);
                }
            } else {
                MekanismClient.clientSecurityMap.clear();
                message.securityMap.forEach(MekanismClient.clientSecurityMap::put);
                message.uuidMap.forEach(MekanismClient.clientUUIDMap::put);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSecurityUpdate pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.isUpdate);
        if (pkt.isUpdate) {
            buf.func_179252_a(pkt.playerUUID);
            buf.func_180714_a(pkt.playerUsername);
            if (pkt.securityData == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                pkt.securityData.write(buf);
            }
        } else {
            ArrayList<SecurityFrequency> frequencies = new ArrayList<SecurityFrequency>(FrequencyType.SECURITY.getManager(null).getFrequencies());
            buf.func_150787_b(frequencies.size());
            for (SecurityFrequency frequency : frequencies) {
                UUID owner = frequency.getOwner();
                buf.func_179252_a(owner);
                new SecurityData(frequency).write(buf);
                buf.func_180714_a(MekanismUtils.getLastKnownUsername(owner));
            }
        }
    }

    public static PacketSecurityUpdate decode(PacketBuffer buf) {
        PacketSecurityUpdate packet = new PacketSecurityUpdate(buf.readBoolean());
        if (packet.isUpdate) {
            packet.playerUUID = buf.func_179253_g();
            packet.playerUsername = BasePacketHandler.readString(buf);
            if (buf.readBoolean()) {
                packet.securityData = SecurityData.read(buf);
            }
        } else {
            int frequencySize = buf.func_150792_a();
            packet.securityMap = new Object2ObjectOpenHashMap(frequencySize);
            packet.uuidMap = new Object2ObjectOpenHashMap(frequencySize);
            for (int i = 0; i < frequencySize; ++i) {
                UUID uuid = buf.func_179253_g();
                packet.securityMap.put(uuid, SecurityData.read(buf));
                packet.uuidMap.put(uuid, BasePacketHandler.readString(buf));
            }
        }
        return packet;
    }
}

