/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IgnoredIInventory;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.impl.SmeltingIRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistry;

public class MekanismRecipeType<RECIPE_TYPE extends MekanismRecipe>
implements IRecipeType<RECIPE_TYPE> {
    private static final List<MekanismRecipeType<? extends MekanismRecipe>> types = new ArrayList<MekanismRecipeType<? extends MekanismRecipe>>();
    public static final MekanismRecipeType<ItemStackToItemStackRecipe> CRUSHING = MekanismRecipeType.create("crushing");
    public static final MekanismRecipeType<ItemStackToItemStackRecipe> ENRICHING = MekanismRecipeType.create("enriching");
    public static final MekanismRecipeType<ItemStackToItemStackRecipe> SMELTING = MekanismRecipeType.create("smelting");
    public static final MekanismRecipeType<ChemicalInfuserRecipe> CHEMICAL_INFUSING = MekanismRecipeType.create("chemical_infusing");
    public static final MekanismRecipeType<CombinerRecipe> COMBINING = MekanismRecipeType.create("combining");
    public static final MekanismRecipeType<ElectrolysisRecipe> SEPARATING = MekanismRecipeType.create("separating");
    public static final MekanismRecipeType<FluidSlurryToSlurryRecipe> WASHING = MekanismRecipeType.create("washing");
    public static final MekanismRecipeType<FluidToFluidRecipe> EVAPORATING = MekanismRecipeType.create("evaporating");
    public static final MekanismRecipeType<GasToGasRecipe> ACTIVATING = MekanismRecipeType.create("activating");
    public static final MekanismRecipeType<GasToGasRecipe> CENTRIFUGING = MekanismRecipeType.create("centrifuging");
    public static final MekanismRecipeType<ChemicalCrystallizerRecipe> CRYSTALLIZING = MekanismRecipeType.create("crystallizing");
    public static final MekanismRecipeType<ChemicalDissolutionRecipe> DISSOLUTION = MekanismRecipeType.create("dissolution");
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe> COMPRESSING = MekanismRecipeType.create("compressing");
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe> PURIFYING = MekanismRecipeType.create("purifying");
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe> INJECTING = MekanismRecipeType.create("injecting");
    public static final MekanismRecipeType<NucleosynthesizingRecipe> NUCLEOSYNTHESIZING = MekanismRecipeType.create("nucleosynthesizing");
    public static final MekanismRecipeType<ItemStackToEnergyRecipe> ENERGY_CONVERSION = MekanismRecipeType.create("energy_conversion");
    public static final MekanismRecipeType<ItemStackToGasRecipe> GAS_CONVERSION = MekanismRecipeType.create("gas_conversion");
    public static final MekanismRecipeType<ItemStackToGasRecipe> OXIDIZING = MekanismRecipeType.create("oxidizing");
    public static final MekanismRecipeType<ItemStackToInfuseTypeRecipe> INFUSION_CONVERSION = MekanismRecipeType.create("infusion_conversion");
    public static final MekanismRecipeType<MetallurgicInfuserRecipe> METALLURGIC_INFUSING = MekanismRecipeType.create("metallurgic_infusing");
    public static final MekanismRecipeType<PressurizedReactionRecipe> REACTION = MekanismRecipeType.create("reaction");
    public static final MekanismRecipeType<RotaryRecipe> ROTARY = MekanismRecipeType.create("rotary");
    public static final MekanismRecipeType<SawmillRecipe> SAWING = MekanismRecipeType.create("sawing");
    private List<RECIPE_TYPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;

    private static <RECIPE_TYPE extends MekanismRecipe> MekanismRecipeType<RECIPE_TYPE> create(String name) {
        MekanismRecipeType<RECIPE_TYPE> type = new MekanismRecipeType<RECIPE_TYPE>(name);
        types.add(type);
        return type;
    }

    public static void registerRecipeTypes(IForgeRegistry<IRecipeSerializer<?>> registry) {
        types.forEach(type -> {
            MekanismRecipeType cfr_ignored_0 = (MekanismRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)type.registryName, (Object)type);
        });
    }

    public static void clearCache() {
        types.forEach(type -> type.cachedRecipes.clear());
    }

    private MekanismRecipeType(String name) {
        this.registryName = Mekanism.rl(name);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Nonnull
    public List<RECIPE_TYPE> getRecipes(@Nullable World world) {
        if (world == null && (world = (World)DistExecutor.safeRunForDist(() -> MekanismClient::tryGetClientWorld, () -> (DistExecutor.SafeSupplier & Serializable)() -> ServerLifecycleHooks.getCurrentServer().func_241755_D_())) == null) {
            return Collections.emptyList();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.func_199532_z();
            ArrayList<SmeltingIRecipe> recipes = recipeManager.func_215370_b((IRecipeType)this, (IInventory)IgnoredIInventory.INSTANCE, world);
            if (this == SMELTING) {
                Map smeltingRecipes = recipeManager.func_215366_a(IRecipeType.field_222150_b);
                recipes = new ArrayList<SmeltingIRecipe>(recipes);
                for (Map.Entry entry : smeltingRecipes.entrySet()) {
                    ItemStackIngredient input;
                    NonNullList ingredients;
                    IRecipe smeltingRecipe = (IRecipe)entry.getValue();
                    ItemStack recipeOutput = smeltingRecipe.func_77571_b();
                    if (smeltingRecipe.func_192399_d() || recipeOutput.func_190926_b() || (ingredients = smeltingRecipe.func_192400_c()).isEmpty()) continue;
                    if (ingredients.size() == 1) {
                        input = ItemStackIngredient.from((Ingredient)ingredients.get(0));
                    } else {
                        ItemStackIngredient[] itemIngredients = new ItemStackIngredient[ingredients.size()];
                        for (int i = 0; i < ingredients.size(); ++i) {
                            itemIngredients[i] = ItemStackIngredient.from((Ingredient)ingredients.get(i));
                        }
                        input = ItemStackIngredient.createMulti(itemIngredients);
                    }
                    recipes.add(new SmeltingIRecipe((ResourceLocation)entry.getKey(), input, recipeOutput));
                }
            }
            this.cachedRecipes = recipes;
        }
        return this.cachedRecipes;
    }

    public Stream<RECIPE_TYPE> stream(@Nullable World world) {
        return this.getRecipes(world).stream();
    }

    @Nullable
    public RECIPE_TYPE findFirst(@Nullable World world, Predicate<RECIPE_TYPE> matchCriteria) {
        return (RECIPE_TYPE)((MekanismRecipe)this.stream(world).filter(matchCriteria).findFirst().orElse(null));
    }

    public boolean contains(@Nullable World world, Predicate<RECIPE_TYPE> matchCriteria) {
        return this.stream(world).anyMatch(matchCriteria);
    }
}

