/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.ItemRobit;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISustainedInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRecipeData
implements RecipeUpgradeData<ItemRecipeData> {
    private final List<IInventorySlot> slots;

    ItemRecipeData(ListNBT slots) {
        int count = DataHandlerUtils.getMaxId(slots, "Slot");
        this.slots = new ArrayList<IInventorySlot>(count);
        for (int i = 0; i < count; ++i) {
            this.slots.add(new DummyInventorySlot());
        }
        DataHandlerUtils.readContainers(this.slots, slots);
    }

    private ItemRecipeData(List<IInventorySlot> slots) {
        this.slots = slots;
    }

    @Override
    @Nullable
    public ItemRecipeData merge(ItemRecipeData other) {
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots.size() + other.slots.size());
        allSlots.addAll(this.slots);
        allSlots.addAll(other.slots);
        return new ItemRecipeData(allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        int slot;
        int i;
        if (this.slots.isEmpty()) {
            return true;
        }
        Item item = stack.func_77973_b();
        boolean isBin = item instanceof ItemBlockBin;
        Optional capability = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        final ArrayList<DummyInventorySlot> slots = new ArrayList<DummyInventorySlot>();
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.get();
            i = 0;
            while (i < itemHandler.getSlots()) {
                slot = i++;
                slots.add(new DummyInventorySlot(itemHandler.getSlotLimit(slot), itemStack -> itemHandler.isItemValid(slot, itemStack), isBin));
            }
        } else if (item instanceof BlockItem) {
            TileEntityMekanism tile = this.getTileFromBlock(((BlockItem)item).func_179223_d());
            if (tile == null || !tile.persistInventory()) {
                return false;
            }
            i = 0;
            while (i < tile.getSlots()) {
                slot = i++;
                slots.add(new DummyInventorySlot(tile.getSlotLimit(slot), itemStack -> tile.isItemValid(slot, (ItemStack)itemStack), isBin));
            }
        } else if (item instanceof ItemRobit) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                for (int slotX = 0; slotX < 9; ++slotX) {
                    slots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
                }
            }
            slots.add(new DummyInventorySlot(64, itemStack -> {
                if (EnergyCompatUtils.hasStrictEnergyHandler(itemStack)) {
                    return true;
                }
                ItemStackToEnergyRecipe foundRecipe = MekanismRecipeType.ENERGY_CONVERSION.findFirst(null, recipe -> recipe.getInput().testType(itemStack));
                return foundRecipe != null && !foundRecipe.getOutput((ItemStack)itemStack).isZero();
            }, false));
            slots.add(new DummyInventorySlot(64, itemStack -> MekanismRecipeType.SMELTING.contains(null, recipe -> recipe.getInput().testType(itemStack)), false));
            slots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
        } else {
            if (item instanceof ISustainedInventory) {
                for (IInventorySlot slot2 : this.slots) {
                    if (slot2.isEmpty()) continue;
                    ((ISustainedInventory)stack.func_77973_b()).setInventory(DataHandlerUtils.writeContainers(this.slots), stack);
                    return true;
                }
                return true;
            }
            return false;
        }
        if (slots.isEmpty()) {
            return true;
        }
        IMekanismInventory outputHandler = new IMekanismInventory(){

            @Override
            @Nonnull
            public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
                return slots;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IInventorySlot slot3 : this.slots) {
            if (slot3.isEmpty()) continue;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)slot3.getStack(), (boolean)false).func_190926_b()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ((ISustainedInventory)stack.func_77973_b()).setInventory(DataHandlerUtils.writeContainers(slots), stack);
        }
        return true;
    }

    private static class DummyInventorySlot
    extends BasicInventorySlot {
        private DummyInventorySlot() {
            this(Integer.MAX_VALUE, alwaysTrue, true);
        }

        private DummyInventorySlot(int capacity, Predicate<@NonNull ItemStack> validator, boolean isBin) {
            super(capacity, alwaysTrueBi, alwaysTrueBi, validator, null, 0, 0);
            if (isBin) {
                this.obeyStackLimit = false;
            }
        }
    }
}

