/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.registration.WrappedDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemDeferredRegister
extends WrappedDeferredRegister<Item> {
    private final List<IItemProvider> allItems = new ArrayList<IItemProvider>();

    public ItemDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ITEMS);
    }

    public static Item.Properties getMekBaseProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)Mekanism.tabMekanism);
    }

    public ItemRegistryObject<Item> register(String name) {
        return this.register(name, Item::new);
    }

    public ItemRegistryObject<Item> registerUnburnable(String name) {
        return this.registerUnburnable(name, Item::new);
    }

    public ItemRegistryObject<Item> register(String name, Rarity rarity) {
        return this.register(name, (Item.Properties properties) -> new Item(properties.func_208103_a(rarity)));
    }

    public ItemRegistryObject<Item> register(String name, final EnumColor color) {
        return this.register(name, (Item.Properties properties) -> new Item((Item.Properties)properties){

            @Nonnull
            public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
                return TextComponentUtil.build(color, super.func_200295_i(stack));
            }
        });
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getMekBaseProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> registerUnburnable(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getMekBaseProperties().func_234689_a_()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Supplier<? extends ITEM> sup) {
        ItemRegistryObject registeredItem = this.register(name, sup, ItemRegistryObject::new);
        this.allItems.add(registeredItem);
        return registeredItem;
    }

    public List<IItemProvider> getAllItems() {
        return this.allItems;
    }
}

