/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.Modules;
import mekanism.common.item.ItemAlloy;
import mekanism.common.item.ItemConfigurationCard;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.item.ItemDictionary;
import mekanism.common.item.ItemDosimeter;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.item.ItemGeigerCounter;
import mekanism.common.item.ItemModule;
import mekanism.common.item.ItemNetworkReader;
import mekanism.common.item.ItemPortableQIODashboard;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.item.ItemQIODrive;
import mekanism.common.item.ItemRefinedGlowstoneIngot;
import mekanism.common.item.ItemRobit;
import mekanism.common.item.ItemSeismicReader;
import mekanism.common.item.ItemTierInstaller;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.item.gear.ItemArmoredJetpack;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.gear.ItemCanteen;
import mekanism.common.item.gear.ItemElectricBow;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.resource.IResource;
import mekanism.common.resource.MiscResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tier.QIODriveTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;

public class MekanismItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekanism");
    public static final Table<ResourceType, PrimaryResource, ItemRegistryObject<Item>> PROCESSED_RESOURCES = HashBasedTable.create();
    public static final Map<Modules.ModuleData<?>, ItemRegistryObject<? extends ItemModule>> MODULES = new LinkedHashMap();
    public static final ItemRegistryObject<ItemRobit> ROBIT = ITEMS.register("robit", ItemRobit::new);
    public static final ItemRegistryObject<ItemEnergized> ENERGY_TABLET = ITEMS.register("energy_tablet", () -> new ItemEnergized(MekanismConfig.gear.tabletChargeRate, MekanismConfig.gear.tabletMaxEnergy, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, ItemDeferredRegister.getMekBaseProperties().func_208103_a(Rarity.UNCOMMON)));
    public static final ItemRegistryObject<ItemConfigurator> CONFIGURATOR = ITEMS.register("configurator", ItemConfigurator::new);
    public static final ItemRegistryObject<ItemNetworkReader> NETWORK_READER = ITEMS.register("network_reader", ItemNetworkReader::new);
    public static final ItemRegistryObject<ItemDictionary> DICTIONARY = ITEMS.register("dictionary", ItemDictionary::new);
    public static final ItemRegistryObject<ItemPortableTeleporter> PORTABLE_TELEPORTER = ITEMS.register("portable_teleporter", ItemPortableTeleporter::new);
    public static final ItemRegistryObject<ItemConfigurationCard> CONFIGURATION_CARD = ITEMS.register("configuration_card", ItemConfigurationCard::new);
    public static final ItemRegistryObject<ItemCraftingFormula> CRAFTING_FORMULA = ITEMS.register("crafting_formula", ItemCraftingFormula::new);
    public static final ItemRegistryObject<ItemSeismicReader> SEISMIC_READER = ITEMS.register("seismic_reader", ItemSeismicReader::new);
    public static final ItemRegistryObject<ItemGaugeDropper> GAUGE_DROPPER = ITEMS.register("gauge_dropper", ItemGaugeDropper::new);
    public static final ItemRegistryObject<ItemGeigerCounter> GEIGER_COUNTER = ITEMS.register("geiger_counter", ItemGeigerCounter::new);
    public static final ItemRegistryObject<ItemDosimeter> DOSIMETER = ITEMS.register("dosimeter", ItemDosimeter::new);
    public static final ItemRegistryObject<ItemCanteen> CANTEEN = ITEMS.register("canteen", ItemCanteen::new);
    public static final ItemRegistryObject<ItemPortableQIODashboard> PORTABLE_QIO_DASHBOARD = ITEMS.register("portable_qio_dashboard", ItemPortableQIODashboard::new);
    public static final ItemRegistryObject<ItemQIODrive> BASE_QIO_DRIVE = MekanismItems.registerQIODrive(QIODriveTier.BASE);
    public static final ItemRegistryObject<ItemQIODrive> HYPER_DENSE_QIO_DRIVE = MekanismItems.registerQIODrive(QIODriveTier.HYPER_DENSE);
    public static final ItemRegistryObject<ItemQIODrive> TIME_DILATING_QIO_DRIVE = MekanismItems.registerQIODrive(QIODriveTier.TIME_DILATING);
    public static final ItemRegistryObject<ItemQIODrive> SUPERMASSIVE_QIO_DRIVE = MekanismItems.registerQIODrive(QIODriveTier.SUPERMASSIVE);
    public static final ItemRegistryObject<ItemAtomicDisassembler> ATOMIC_DISASSEMBLER = ITEMS.register("atomic_disassembler", ItemAtomicDisassembler::new);
    public static final ItemRegistryObject<ItemElectricBow> ELECTRIC_BOW = ITEMS.register("electric_bow", ItemElectricBow::new);
    public static final ItemRegistryObject<ItemFlamethrower> FLAMETHROWER = ITEMS.register("flamethrower", ItemFlamethrower::new);
    public static final ItemRegistryObject<ItemMekaTool> MEKA_TOOL = ITEMS.registerUnburnable("meka_tool", ItemMekaTool::new);
    public static final ItemRegistryObject<ItemFreeRunners> FREE_RUNNERS = ITEMS.register("free_runners", ItemFreeRunners::new);
    public static final ItemRegistryObject<ItemScubaMask> SCUBA_MASK = ITEMS.register("scuba_mask", ItemScubaMask::new);
    public static final ItemRegistryObject<ItemScubaTank> SCUBA_TANK = ITEMS.register("scuba_tank", ItemScubaTank::new);
    public static final ItemRegistryObject<ItemJetpack> JETPACK = ITEMS.register("jetpack", ItemJetpack::new);
    public static final ItemRegistryObject<ItemArmoredJetpack> ARMORED_JETPACK = ITEMS.register("jetpack_armored", ItemArmoredJetpack::new);
    public static final ItemRegistryObject<ItemHazmatSuitArmor> HAZMAT_MASK = ITEMS.register("hazmat_mask", props -> new ItemHazmatSuitArmor(EquipmentSlotType.HEAD, (Item.Properties)props));
    public static final ItemRegistryObject<ItemHazmatSuitArmor> HAZMAT_GOWN = ITEMS.register("hazmat_gown", props -> new ItemHazmatSuitArmor(EquipmentSlotType.CHEST, (Item.Properties)props));
    public static final ItemRegistryObject<ItemHazmatSuitArmor> HAZMAT_PANTS = ITEMS.register("hazmat_pants", props -> new ItemHazmatSuitArmor(EquipmentSlotType.LEGS, (Item.Properties)props));
    public static final ItemRegistryObject<ItemHazmatSuitArmor> HAZMAT_BOOTS = ITEMS.register("hazmat_boots", props -> new ItemHazmatSuitArmor(EquipmentSlotType.FEET, (Item.Properties)props));
    public static final ItemRegistryObject<ItemMekaSuitArmor> MEKASUIT_HELMET = ITEMS.registerUnburnable("mekasuit_helmet", props -> new ItemMekaSuitArmor(EquipmentSlotType.HEAD, (Item.Properties)props));
    public static final ItemRegistryObject<ItemMekaSuitArmor> MEKASUIT_BODYARMOR = ITEMS.registerUnburnable("mekasuit_bodyarmor", props -> new ItemMekaSuitArmor(EquipmentSlotType.CHEST, (Item.Properties)props));
    public static final ItemRegistryObject<ItemMekaSuitArmor> MEKASUIT_PANTS = ITEMS.registerUnburnable("mekasuit_pants", props -> new ItemMekaSuitArmor(EquipmentSlotType.LEGS, (Item.Properties)props));
    public static final ItemRegistryObject<ItemMekaSuitArmor> MEKASUIT_BOOTS = ITEMS.registerUnburnable("mekasuit_boots", props -> new ItemMekaSuitArmor(EquipmentSlotType.FEET, (Item.Properties)props));
    public static final ItemRegistryObject<Item> MODULE_BASE = ITEMS.register("module_base");
    public static final ItemRegistryObject<ItemUpgrade> SPEED_UPGRADE;
    public static final ItemRegistryObject<ItemUpgrade> ENERGY_UPGRADE;
    public static final ItemRegistryObject<ItemUpgrade> FILTER_UPGRADE;
    public static final ItemRegistryObject<ItemUpgrade> MUFFLING_UPGRADE;
    public static final ItemRegistryObject<ItemUpgrade> GAS_UPGRADE;
    public static final ItemRegistryObject<ItemUpgrade> ANCHOR_UPGRADE;
    public static final ItemRegistryObject<ItemTierInstaller> BASIC_TIER_INSTALLER;
    public static final ItemRegistryObject<ItemTierInstaller> ADVANCED_TIER_INSTALLER;
    public static final ItemRegistryObject<ItemTierInstaller> ELITE_TIER_INSTALLER;
    public static final ItemRegistryObject<ItemTierInstaller> ULTIMATE_TIER_INSTALLER;
    public static final ItemRegistryObject<Item> BASIC_CONTROL_CIRCUIT;
    public static final ItemRegistryObject<Item> ADVANCED_CONTROL_CIRCUIT;
    public static final ItemRegistryObject<Item> ELITE_CONTROL_CIRCUIT;
    public static final ItemRegistryObject<Item> ULTIMATE_CONTROL_CIRCUIT;
    public static final ItemRegistryObject<ItemAlloy> INFUSED_ALLOY;
    public static final ItemRegistryObject<ItemAlloy> REINFORCED_ALLOY;
    public static final ItemRegistryObject<ItemAlloy> ATOMIC_ALLOY;
    public static final ItemRegistryObject<Item> ENRICHED_CARBON;
    public static final ItemRegistryObject<Item> ENRICHED_REDSTONE;
    public static final ItemRegistryObject<Item> ENRICHED_DIAMOND;
    public static final ItemRegistryObject<Item> ENRICHED_OBSIDIAN;
    public static final ItemRegistryObject<Item> ENRICHED_GOLD;
    public static final ItemRegistryObject<Item> ENRICHED_TIN;
    public static final ItemRegistryObject<Item> HDPE_PELLET;
    public static final ItemRegistryObject<Item> HDPE_ROD;
    public static final ItemRegistryObject<Item> HDPE_SHEET;
    public static final ItemRegistryObject<Item> HDPE_STICK;
    public static final ItemRegistryObject<Item> ELECTROLYTIC_CORE;
    public static final ItemRegistryObject<Item> TELEPORTATION_CORE;
    public static final ItemRegistryObject<Item> ANTIMATTER_PELLET;
    public static final ItemRegistryObject<Item> PLUTONIUM_PELLET;
    public static final ItemRegistryObject<Item> POLONIUM_PELLET;
    public static final ItemRegistryObject<Item> REPROCESSED_FISSILE_FRAGMENT;
    public static final ItemRegistryObject<Item> ENRICHED_IRON;
    public static final ItemRegistryObject<Item> SAWDUST;
    public static final ItemRegistryObject<Item> SALT;
    public static final ItemRegistryObject<Item> SUBSTRATE;
    public static final ItemRegistryObject<Item> BIO_FUEL;
    public static final ItemRegistryObject<Item> FLUORITE_GEM;
    public static final ItemRegistryObject<Item> YELLOW_CAKE_URANIUM;
    public static final ItemRegistryObject<Item> DIRTY_NETHERITE_SCRAP;
    public static final ItemRegistryObject<Item> BRONZE_DUST;
    public static final ItemRegistryObject<Item> LAPIS_LAZULI_DUST;
    public static final ItemRegistryObject<Item> COAL_DUST;
    public static final ItemRegistryObject<Item> CHARCOAL_DUST;
    public static final ItemRegistryObject<Item> QUARTZ_DUST;
    public static final ItemRegistryObject<Item> EMERALD_DUST;
    public static final ItemRegistryObject<Item> DIAMOND_DUST;
    public static final ItemRegistryObject<Item> NETHERITE_DUST;
    public static final ItemRegistryObject<Item> STEEL_DUST;
    public static final ItemRegistryObject<Item> SULFUR_DUST;
    public static final ItemRegistryObject<Item> LITHIUM_DUST;
    public static final ItemRegistryObject<Item> REFINED_OBSIDIAN_DUST;
    public static final ItemRegistryObject<Item> OBSIDIAN_DUST;
    public static final ItemRegistryObject<Item> FLUORITE_DUST;
    public static final ItemRegistryObject<Item> BRONZE_INGOT;
    public static final ItemRegistryObject<Item> REFINED_OBSIDIAN_INGOT;
    public static final ItemRegistryObject<Item> REFINED_GLOWSTONE_INGOT;
    public static final ItemRegistryObject<Item> STEEL_INGOT;
    public static final ItemRegistryObject<Item> REFINED_OBSIDIAN_NUGGET;
    public static final ItemRegistryObject<Item> BRONZE_NUGGET;
    public static final ItemRegistryObject<Item> REFINED_GLOWSTONE_NUGGET;
    public static final ItemRegistryObject<Item> STEEL_NUGGET;

    private MekanismItems() {
    }

    private static ItemRegistryObject<Item> registerResource(ResourceType type, IResource resource) {
        return ITEMS.register(type.getRegistryPrefix() + "_" + resource.getRegistrySuffix());
    }

    private static ItemRegistryObject<Item> registerUnburnableResource(ResourceType type, IResource resource) {
        return ITEMS.registerUnburnable(type.getRegistryPrefix() + "_" + resource.getRegistrySuffix());
    }

    private static ItemRegistryObject<Item> registerCircuit(BaseTier tier) {
        return ITEMS.register(tier.getLowerName() + "_control_circuit", tier.getTextColor());
    }

    private static ItemRegistryObject<ItemTierInstaller> registerInstaller(@Nullable BaseTier fromTier, @Nonnull BaseTier toTier) {
        return ITEMS.register(toTier.getLowerName() + "_tier_installer", properties -> new ItemTierInstaller(fromTier, toTier, (Item.Properties)properties));
    }

    private static ItemRegistryObject<ItemAlloy> registerAlloy(AlloyTier tier, Rarity rarity) {
        return ITEMS.register("alloy_" + tier.getName(), properties -> new ItemAlloy(tier, properties.func_208103_a(rarity)));
    }

    private static ItemRegistryObject<ItemUpgrade> registerUpgrade(Upgrade type) {
        return ITEMS.register("upgrade_" + type.getRawName(), properties -> new ItemUpgrade(type, (Item.Properties)properties));
    }

    private static ItemRegistryObject<ItemQIODrive> registerQIODrive(QIODriveTier tier) {
        return ITEMS.register("qio_drive_" + tier.name().toLowerCase(Locale.ROOT), properties -> new ItemQIODrive(tier, (Item.Properties)properties));
    }

    static {
        for (Modules.ModuleData<?> module : Modules.getAll()) {
            MODULES.put(module, ITEMS.register("module_" + module.getName(), properties -> new ItemModule(module, (Item.Properties)properties)));
        }
        SPEED_UPGRADE = MekanismItems.registerUpgrade(Upgrade.SPEED);
        ENERGY_UPGRADE = MekanismItems.registerUpgrade(Upgrade.ENERGY);
        FILTER_UPGRADE = MekanismItems.registerUpgrade(Upgrade.FILTER);
        MUFFLING_UPGRADE = MekanismItems.registerUpgrade(Upgrade.MUFFLING);
        GAS_UPGRADE = MekanismItems.registerUpgrade(Upgrade.GAS);
        ANCHOR_UPGRADE = MekanismItems.registerUpgrade(Upgrade.ANCHOR);
        BASIC_TIER_INSTALLER = MekanismItems.registerInstaller(null, BaseTier.BASIC);
        ADVANCED_TIER_INSTALLER = MekanismItems.registerInstaller(BaseTier.BASIC, BaseTier.ADVANCED);
        ELITE_TIER_INSTALLER = MekanismItems.registerInstaller(BaseTier.ADVANCED, BaseTier.ELITE);
        ULTIMATE_TIER_INSTALLER = MekanismItems.registerInstaller(BaseTier.ELITE, BaseTier.ULTIMATE);
        BASIC_CONTROL_CIRCUIT = MekanismItems.registerCircuit(BaseTier.BASIC);
        ADVANCED_CONTROL_CIRCUIT = MekanismItems.registerCircuit(BaseTier.ADVANCED);
        ELITE_CONTROL_CIRCUIT = MekanismItems.registerCircuit(BaseTier.ELITE);
        ULTIMATE_CONTROL_CIRCUIT = MekanismItems.registerCircuit(BaseTier.ULTIMATE);
        INFUSED_ALLOY = MekanismItems.registerAlloy(AlloyTier.INFUSED, Rarity.UNCOMMON);
        REINFORCED_ALLOY = MekanismItems.registerAlloy(AlloyTier.REINFORCED, Rarity.RARE);
        ATOMIC_ALLOY = MekanismItems.registerAlloy(AlloyTier.ATOMIC, Rarity.EPIC);
        ENRICHED_CARBON = MekanismItems.registerResource(ResourceType.ENRICHED, MiscResource.CARBON);
        ENRICHED_REDSTONE = MekanismItems.registerResource(ResourceType.ENRICHED, MiscResource.REDSTONE);
        ENRICHED_DIAMOND = MekanismItems.registerResource(ResourceType.ENRICHED, MiscResource.DIAMOND);
        ENRICHED_OBSIDIAN = MekanismItems.registerResource(ResourceType.ENRICHED, MiscResource.REFINED_OBSIDIAN);
        ENRICHED_GOLD = MekanismItems.registerResource(ResourceType.ENRICHED, PrimaryResource.GOLD);
        ENRICHED_TIN = MekanismItems.registerResource(ResourceType.ENRICHED, PrimaryResource.TIN);
        HDPE_PELLET = ITEMS.register("hdpe_pellet", Rarity.UNCOMMON);
        HDPE_ROD = ITEMS.register("hdpe_rod", Rarity.UNCOMMON);
        HDPE_SHEET = ITEMS.register("hdpe_sheet", Rarity.UNCOMMON);
        HDPE_STICK = ITEMS.register("hdpe_stick", Rarity.UNCOMMON);
        ELECTROLYTIC_CORE = ITEMS.register("electrolytic_core", Rarity.UNCOMMON);
        TELEPORTATION_CORE = ITEMS.register("teleportation_core", Rarity.RARE);
        ANTIMATTER_PELLET = ITEMS.register("pellet_antimatter", EnumColor.PURPLE);
        PLUTONIUM_PELLET = ITEMS.register("pellet_plutonium", EnumColor.GRAY);
        POLONIUM_PELLET = ITEMS.register("pellet_polonium", EnumColor.INDIGO);
        REPROCESSED_FISSILE_FRAGMENT = ITEMS.register("reprocessed_fissile_fragment", Rarity.RARE);
        ENRICHED_IRON = ITEMS.register("enriched_iron");
        SAWDUST = ITEMS.register("sawdust");
        SALT = ITEMS.register("salt");
        SUBSTRATE = ITEMS.register("substrate");
        BIO_FUEL = ITEMS.register("bio_fuel");
        FLUORITE_GEM = ITEMS.register("fluorite_gem");
        YELLOW_CAKE_URANIUM = ITEMS.register("yellow_cake_uranium", Rarity.UNCOMMON);
        DIRTY_NETHERITE_SCRAP = ITEMS.registerUnburnable("dirty_netherite_scrap");
        BRONZE_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.BRONZE);
        LAPIS_LAZULI_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.LAPIS_LAZULI);
        COAL_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.COAL);
        CHARCOAL_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.CHARCOAL);
        QUARTZ_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.QUARTZ);
        EMERALD_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.EMERALD);
        DIAMOND_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.DIAMOND);
        NETHERITE_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.NETHERITE);
        STEEL_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.STEEL);
        SULFUR_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.SULFUR);
        LITHIUM_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.LITHIUM);
        REFINED_OBSIDIAN_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.REFINED_OBSIDIAN);
        OBSIDIAN_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.OBSIDIAN);
        FLUORITE_DUST = MekanismItems.registerResource(ResourceType.DUST, MiscResource.FLUORITE);
        BRONZE_INGOT = MekanismItems.registerResource(ResourceType.INGOT, MiscResource.BRONZE);
        REFINED_OBSIDIAN_INGOT = MekanismItems.registerUnburnableResource(ResourceType.INGOT, MiscResource.REFINED_OBSIDIAN);
        REFINED_GLOWSTONE_INGOT = ITEMS.register(ResourceType.INGOT.getRegistryPrefix() + "_" + MiscResource.REFINED_GLOWSTONE.getRegistrySuffix(), ItemRefinedGlowstoneIngot::new);
        STEEL_INGOT = MekanismItems.registerResource(ResourceType.INGOT, MiscResource.STEEL);
        REFINED_OBSIDIAN_NUGGET = MekanismItems.registerUnburnableResource(ResourceType.NUGGET, MiscResource.REFINED_OBSIDIAN);
        BRONZE_NUGGET = MekanismItems.registerResource(ResourceType.NUGGET, MiscResource.BRONZE);
        REFINED_GLOWSTONE_NUGGET = MekanismItems.registerResource(ResourceType.NUGGET, MiscResource.REFINED_GLOWSTONE);
        STEEL_NUGGET = MekanismItems.registerResource(ResourceType.NUGGET, MiscResource.STEEL);
        for (ResourceType type : EnumUtils.RESOURCE_TYPES) {
            for (PrimaryResource resource : EnumUtils.PRIMARY_RESOURCES) {
                if (!resource.has(type)) continue;
                PROCESSED_RESOURCES.put((Object)type, (Object)resource, ITEMS.register(type.getRegistryPrefix() + "_" + resource.getName()));
            }
        }
    }
}

