/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.UUID;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileComponentSecurity
implements ITileComponent {
    public final TileEntityMekanism tile;
    private UUID ownerUUID;
    private String ownerName;
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public TileComponentSecurity(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
        tile.getFrequencyComponent().track(FrequencyType.SECURITY, true, false, true);
    }

    public SecurityFrequency getFrequency() {
        return (SecurityFrequency)this.tile.getFrequency(FrequencyType.SECURITY);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.tile.getFrequencyComponent().setFrequency(FrequencyType.SECURITY, null);
        this.ownerUUID = uuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public SecurityMode getMode() {
        if (MekanismConfig.general.allowProtection.get()) {
            return this.securityMode;
        }
        return SecurityMode.PUBLIC;
    }

    public void setMode(SecurityMode mode) {
        if (this.securityMode != mode) {
            SecurityMode old = this.securityMode;
            this.securityMode = mode;
            this.tile.markDirty(false);
            this.tile.onSecurityChanged(old, this.securityMode);
        }
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote() && this.getFrequency() == null && this.ownerUUID != null) {
            this.tile.getFrequencyComponent().setFrequencyFromData(FrequencyType.SECURITY, new Frequency.FrequencyIdentity(this.ownerUUID, true));
        }
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentSecurity", 10)) {
            CompoundNBT securityNBT = nbtTags.func_74775_l("componentSecurity");
            NBTUtils.setEnumIfPresent(securityNBT, "securityMode", SecurityMode::byIndexStatic, mode -> {
                this.securityMode = mode;
            });
            NBTUtils.setUUIDIfPresent(securityNBT, "owner", uuid -> {
                this.ownerUUID = uuid;
            });
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT securityNBT = new CompoundNBT();
        securityNBT.func_74768_a("securityMode", this.securityMode.ordinal());
        if (this.ownerUUID != null) {
            securityNBT.func_186854_a("owner", this.ownerUUID);
        }
        nbtTags.func_218657_a("componentSecurity", (INBT)securityNBT);
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        container.track(SyncableEnum.create(SecurityMode::byIndexStatic, SecurityMode.PUBLIC, this::getMode, this::setMode));
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
        if (this.ownerUUID != null) {
            updateTag.func_186854_a("owner", this.ownerUUID);
            updateTag.func_74778_a("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
        NBTUtils.setUUIDIfPresent(updateTag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(updateTag, "ownerName", uuid -> {
            this.ownerName = uuid;
        });
    }
}

