/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.Upgrade;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileComponentUpgrade
implements ITileComponent,
ITrackableContainer {
    private static final int UPGRADE_TICKS_REQUIRED = 40;
    private int upgradeTicks;
    private final TileEntityMekanism tile;
    private Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private final Set<Upgrade> supported = EnumSet.noneOf(Upgrade.class);
    private final UpgradeInventorySlot upgradeSlot;

    public TileComponentUpgrade(TileEntityMekanism tile, @Nonnull UpgradeInventorySlot slot) {
        this.tile = tile;
        this.upgradeSlot = slot;
        slot.getSupportedUpgrade().forEach(this::setSupported);
        tile.addComponent(this);
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote()) {
            ItemStack stack = this.upgradeSlot.getStack();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeItem) {
                Upgrade type = ((IUpgradeItem)stack.func_77973_b()).getUpgradeType(stack);
                if (this.supports(type) && this.getUpgrades(type) < type.getMax()) {
                    if (this.upgradeTicks < 40) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == 40) {
                        this.upgradeTicks = 0;
                        this.addUpgrade(type);
                        MekanismUtils.logMismatchedStackSize(this.upgradeSlot.shrinkStack(1, Action.EXECUTE), 1L);
                        if (type == Upgrade.MUFFLING) {
                            this.tile.sendUpdatePacket();
                        }
                        this.tile.markDirty(false);
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
        }
    }

    public UpgradeInventorySlot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public double getScaledUpgradeProgress() {
        return (double)this.upgradeTicks / 40.0;
    }

    public int getUpgrades(Upgrade upgrade) {
        return this.upgrades.getOrDefault(upgrade, 0);
    }

    public void addUpgrade(Upgrade upgrade) {
        this.upgrades.put(upgrade, Math.min(upgrade.getMax(), this.getUpgrades(upgrade) + 1));
        this.tile.recalculateUpgrades(upgrade);
    }

    public void removeUpgrade(Upgrade upgrade) {
        this.upgrades.put(upgrade, Math.max(0, this.getUpgrades(upgrade) - 1));
        if (this.upgrades.get(upgrade) == 0) {
            this.upgrades.remove(upgrade);
        }
        this.tile.recalculateUpgrades(upgrade);
    }

    public void setSupported(Upgrade upgrade) {
        this.setSupported(upgrade, true);
    }

    public void setSupported(Upgrade upgrade, boolean isSupported) {
        if (isSupported) {
            this.supported.add(upgrade);
        } else {
            this.supported.remove(upgrade);
        }
    }

    public boolean supports(Upgrade upgrade) {
        return this.supported.contains(upgrade);
    }

    public boolean isUpgradeInstalled(Upgrade upgrade) {
        return this.upgrades.containsKey(upgrade);
    }

    public Set<Upgrade> getInstalledTypes() {
        return this.upgrades.keySet();
    }

    public Set<Upgrade> getSupportedTypes() {
        return this.supported;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentUpgrade", 10)) {
            CompoundNBT upgradeNBT = nbtTags.func_74775_l("componentUpgrade");
            this.upgrades = Upgrade.buildMap(upgradeNBT);
            for (Upgrade upgrade : this.getSupportedTypes()) {
                this.tile.recalculateUpgrades(upgrade);
            }
            NBTUtils.setCompoundIfPresent(upgradeNBT, "Slot", this.upgradeSlot::deserializeNBT);
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT upgradeNBT = new CompoundNBT();
        Upgrade.saveMap(this.upgrades, upgradeNBT);
        CompoundNBT compoundNBT = this.upgradeSlot.serializeNBT();
        if (!compoundNBT.isEmpty()) {
            upgradeNBT.func_218657_a("Slot", (INBT)compoundNBT);
        }
        nbtTags.func_218657_a("componentUpgrade", (INBT)upgradeNBT);
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            updateTag.func_74768_a("muffling", this.upgrades.getOrDefault(Upgrade.MUFFLING, 0).intValue());
        }
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            NBTUtils.setIntIfPresent(updateTag, "muffling", amount -> {
                if (amount == 0) {
                    this.upgrades.remove(Upgrade.MUFFLING);
                } else {
                    this.upgrades.put(Upgrade.MUFFLING, amount);
                }
            });
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(() -> this.upgradeTicks, value -> {
            this.upgradeTicks = value;
        }));
        for (Upgrade upgrade : EnumUtils.UPGRADES) {
            if (!this.supports(upgrade)) continue;
            container.track(SyncableInt.create(() -> this.upgrades.getOrDefault(upgrade, 0), value -> {
                if (value == 0) {
                    this.upgrades.remove(upgrade);
                } else if (value > 0) {
                    this.upgrades.put(upgrade, value);
                }
            }));
        }
    }
}

