/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.base.ProcessInfo;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.FactoryInputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import net.minecraft.item.ItemStack;

public abstract class TileEntityItemToItemFactory<RECIPE extends MekanismRecipe>
extends TileEntityFactory<RECIPE> {
    protected IInputHandler<@NonNull ItemStack>[] inputHandlers;
    protected IOutputHandler<@NonNull ItemStack>[] outputHandlers;

    protected TileEntityItemToItemFactory(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener updateSortingListener) {
        int baseX;
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new ProcessInfo[this.tier.processes];
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < this.tier.processes; ++i) {
            int xPos = baseX + i * baseXMult;
            OutputInventorySlot outputSlot = OutputInventorySlot.at(updateSortingListener, xPos, 57);
            FactoryInputInventorySlot inputSlot = FactoryInputInventorySlot.create(this, i, outputSlot, updateSortingListener, xPos, 13);
            builder.addSlot(inputSlot);
            builder.addSlot(outputSlot);
            this.inputHandlers[i] = InputHelper.getInputHandler(inputSlot);
            this.outputHandlers[i] = OutputHelper.getOutputHandler(outputSlot);
            this.processInfoSlots[i] = new ProcessInfo(i, inputSlot, outputSlot, null);
        }
    }
}

