/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.util.Direction;

public interface ISideConfiguration {
    public TileComponentConfig getConfig();

    public Direction getOrientation();

    public TileComponentEjector getEjector();

    @Nullable
    default public DataType getActiveDataType(Object container) {
        List<DataType> types;
        int count;
        ConfigInfo info = null;
        if (container instanceof IGasTank && this.getConfig().supports(TransmissionType.GAS)) {
            info = this.getConfig().getConfig(TransmissionType.GAS);
        } else if (container instanceof IInfusionTank && this.getConfig().supports(TransmissionType.INFUSION)) {
            info = this.getConfig().getConfig(TransmissionType.INFUSION);
        } else if (container instanceof IPigmentTank && this.getConfig().supports(TransmissionType.PIGMENT)) {
            info = this.getConfig().getConfig(TransmissionType.PIGMENT);
        } else if (container instanceof ISlurryTank && this.getConfig().supports(TransmissionType.SLURRY)) {
            info = this.getConfig().getConfig(TransmissionType.SLURRY);
        } else if (container instanceof IExtendedFluidTank && this.getConfig().supports(TransmissionType.FLUID)) {
            info = this.getConfig().getConfig(TransmissionType.FLUID);
        } else if (container instanceof IInventorySlot && this.getConfig().supports(TransmissionType.ITEM)) {
            info = this.getConfig().getConfig(TransmissionType.ITEM);
        }
        if (info != null && (count = (types = info.getDataTypeForContainer(container)).size()) > 0 && count < info.getSupportedDataTypes().size() - 1) {
            return types.get(0);
        }
        return null;
    }
}

