/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.interfaces.IActiveState;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public class WorldUtils {
    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    private static IChunk getChunkForPos(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        int chunkZ;
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return null;
        }
        int chunkX = pos.func_177958_n() >> 4;
        long combinedChunk = (long)chunkX << 32 | (long)(chunkZ = pos.func_177952_p() >> 4) & 0xFFFFFFFFL;
        IChunk chunk = (IChunk)chunkMap.get(combinedChunk);
        if (chunk == null && (chunk = world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false)) != null) {
            chunkMap.put(combinedChunk, (Object)chunk);
        }
        return chunk;
    }

    @Nonnull
    public static Optional<BlockState> getBlockState(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getBlockState((IBlockReader)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nonnull
    public static Optional<BlockState> getBlockState(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.func_180495_p(pos));
    }

    @Nonnull
    public static Optional<FluidState> getFluidState(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getFluidState((IBlockReader)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nonnull
    public static Optional<FluidState> getFluidState(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.func_204610_c(pos));
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static TileEntity getTileEntity(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity((IBlockReader)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, chunkMap, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos, boolean logWrongType) {
        return WorldUtils.getTileEntity(clazz, (IBlockReader)WorldUtils.getChunkForPos(world, chunkMap, pos), pos, logWrongType);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static TileEntity getTileEntity(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos, boolean logWrongType) {
        TileEntity tile = WorldUtils.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (T)((TileEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            Mekanism.logger.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return null;
    }

    public static void saveChunk(TileEntity tile) {
        if (tile != null && !tile.func_145837_r() && tile.func_145831_w() != null) {
            WorldUtils.markChunkDirty(tile.func_145831_w(), tile.func_174877_v());
        }
    }

    public static void markChunkDirty(World world, BlockPos pos) {
        if (WorldUtils.isBlockLoaded((IBlockReader)world, pos)) {
            world.func_175726_f(pos).func_76630_e();
        }
    }

    public static void dismantleBlock(BlockState state, World world, BlockPos pos) {
        WorldUtils.dismantleBlock(state, world, pos, WorldUtils.getTileEntity((IBlockReader)world, pos));
    }

    public static void dismantleBlock(BlockState state, World world, BlockPos pos, @Nullable TileEntity tile) {
        Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tile);
        world.func_217377_a(pos, false);
    }

    public static double distanceBetween(BlockPos start, BlockPos end) {
        return MathHelper.func_76133_a((double)start.func_177951_i((Vector3i)end));
    }

    public static Direction sideDifference(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.func_177973_b((Vector3i)other);
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (side.func_82601_c() != diff.func_177958_n() || side.func_96559_d() != diff.func_177956_o() || side.func_82599_e() != diff.func_177952_p()) continue;
            return side;
        }
        return null;
    }

    public static boolean isChunkVibrated(ChunkPos chunk, World world) {
        return Mekanism.activeVibrators.stream().anyMatch(coord -> coord.dimension == world.func_234923_W_() && coord.getX() >> 4 == chunk.field_77276_a && coord.getZ() >> 4 == chunk.field_77275_b);
    }

    public static boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World world, BlockPos pos, @Nonnull FluidStack fluidStack, @Nullable Direction side) {
        boolean canContainFluid;
        Fluid fluid = fluidStack.getFluid();
        if (!fluid.getAttributes().canBePlacedInWorld((IBlockDisplayReader)world, pos, fluidStack)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        boolean isReplaceable = state.func_227032_a_(fluid);
        boolean bl = canContainFluid = state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a((IBlockReader)world, pos, state, fluid);
        if (state.isAir((IBlockReader)world, pos) || isReplaceable || canContainFluid) {
            if (world.func_230315_m_().func_236040_e_() && fluid.getAttributes().doesVaporize((IBlockDisplayReader)world, pos, fluidStack)) {
                fluid.getAttributes().vaporize(player, world, pos, fluidStack);
            } else if (canContainFluid) {
                if (!((ILiquidContainer)state.func_177230_c()).func_204509_a((IWorld)world, pos, state, fluid.getAttributes().getStateForPlacement((IBlockDisplayReader)world, pos, fluidStack))) {
                    return false;
                }
                WorldUtils.playEmptySound(player, (IWorld)world, pos, fluidStack);
            } else {
                if (!world.func_201670_d() && isReplaceable && !state.func_185904_a().func_76224_d()) {
                    world.func_175655_b(pos, true);
                }
                WorldUtils.playEmptySound(player, (IWorld)world, pos, fluidStack);
                world.func_180501_a(pos, fluid.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return side != null && WorldUtils.tryPlaceContainedLiquid(player, world, pos.func_177972_a(side), fluidStack, null);
    }

    private static void playEmptySound(@Nullable PlayerEntity player, IWorld world, BlockPos pos, @Nonnull FluidStack fluidStack) {
        SoundEvent soundevent = fluidStack.getFluid().getAttributes().getEmptySound((IBlockDisplayReader)world, pos);
        if (soundevent == null) {
            soundevent = fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static void playFillSound(@Nullable PlayerEntity player, IWorld world, BlockPos pos, @Nonnull FluidStack fluidStack) {
        SoundEvent soundevent = fluidStack.getFluid().getAttributes().getFillSound((IBlockDisplayReader)world, pos);
        if (soundevent == null) {
            soundevent = fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
        }
        world.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static boolean isGettingPowered(World world, BlockPos pos) {
        if (WorldUtils.isBlockLoaded((IBlockReader)world, pos)) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockState blockState;
                boolean weakPower;
                BlockPos offset = pos.func_177972_a(side);
                if (!WorldUtils.isBlockLoaded((IBlockReader)world, offset) || (!(weakPower = (blockState = world.func_180495_p(offset)).func_177230_c().shouldCheckWeakPower(blockState, (IWorldReader)world, pos, side)) || !WorldUtils.isDirectlyGettingPowered(world, offset)) && (weakPower || blockState.func_185911_a((IBlockReader)world, offset, side) <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(World world, BlockPos pos) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = pos.func_177972_a(side);
            if (!WorldUtils.isBlockLoaded((IBlockReader)world, offset) || world.func_175651_c(pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull IBlockReader world, BlockPos ... positions) {
        return WorldUtils.areBlocksValidAndReplaceable(world, Arrays.stream(positions));
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull IBlockReader world, @Nonnull Collection<BlockPos> positions) {
        return WorldUtils.areBlocksValidAndReplaceable(world, positions.stream());
    }

    public static boolean areBlocksValidAndReplaceable(@Nonnull IBlockReader world, @Nonnull Stream<BlockPos> positions) {
        return positions.allMatch(pos -> WorldUtils.isValidReplaceableBlock(world, pos));
    }

    public static boolean isValidReplaceableBlock(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return World.func_175701_a((BlockPos)pos) && world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public static void notifyLoadedNeighborsOfTileChange(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        for (Direction dir : EnumUtils.DIRECTIONS) {
            Block block1;
            BlockPos offset = pos.func_177972_a(dir);
            if (!WorldUtils.isBlockLoaded((IBlockReader)world, offset)) continue;
            WorldUtils.notifyNeighborOfChange(world, offset, pos);
            if (!world.func_180495_p(offset).func_215686_e((IBlockReader)world, offset) || !WorldUtils.isBlockLoaded((IBlockReader)world, offset = offset.func_177972_a(dir)) || !(block1 = world.func_180495_p(offset).func_177230_c()).getWeakChanges(state, (IWorldReader)world, offset)) continue;
            block1.onNeighborChange(state, (IWorldReader)world, offset, pos);
        }
    }

    public static void notifyNeighborOfChange(@Nullable World world, BlockPos pos, BlockPos fromPos) {
        WorldUtils.getBlockState((IBlockReader)world, pos).ifPresent(state -> {
            state.onNeighborChange((IWorldReader)world, pos, fromPos);
            state.func_215697_a(world, pos, world.func_180495_p(fromPos).func_177230_c(), fromPos, false);
        });
    }

    public static void notifyNeighborOfChange(@Nullable World world, Direction neighborSide, BlockPos fromPos) {
        WorldUtils.notifyNeighborOfChange(world, fromPos.func_177972_a(neighborSide), fromPos);
    }

    public static void makeBoundingBlock(@Nullable IWorld world, BlockPos boundingLocation, BlockPos orig) {
        if (world == null) {
            return;
        }
        BlockBounding boundingBlock = MekanismBlocks.BOUNDING_BLOCK.getBlock();
        BlockState newState = BlockStateHelper.getStateForPlacement(boundingBlock, boundingBlock.func_176223_P(), world, boundingLocation, null, Direction.NORTH);
        world.func_180501_a(boundingLocation, newState, 3);
        if (!world.func_201670_d()) {
            TileEntityBoundingBlock tile = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, boundingLocation);
            if (tile != null) {
                tile.setMainLocation(orig);
            } else {
                Mekanism.logger.warn("Unable to find Bounding Block Tile at: {}", (Object)boundingLocation);
            }
        }
    }

    public static void makeAdvancedBoundingBlock(IWorld world, BlockPos boundingLocation, BlockPos orig) {
        BlockBounding boundingBlock = MekanismBlocks.ADVANCED_BOUNDING_BLOCK.getBlock();
        BlockState newState = BlockStateHelper.getStateForPlacement(boundingBlock, boundingBlock.func_176223_P(), world, boundingLocation, null, Direction.NORTH);
        world.func_180501_a(boundingLocation, newState, 3);
        if (!world.func_201670_d()) {
            TileEntityAdvancedBoundingBlock tile = WorldUtils.getTileEntity(TileEntityAdvancedBoundingBlock.class, (IBlockReader)world, boundingLocation);
            if (tile != null) {
                tile.setMainLocation(orig);
            } else {
                Mekanism.logger.warn("Unable to find Advanced Bounding Block Tile at: {}", (Object)boundingLocation);
            }
        }
    }

    public static void updateBlock(@Nullable World world, BlockPos pos, TileEntity tile) {
        if (!WorldUtils.isBlockLoaded((IBlockReader)world, pos)) {
            return;
        }
        BlockState blockState = world.func_180495_p(pos);
        world.func_225319_b(pos, Blocks.field_150350_a.func_176223_P(), blockState);
        if (!(tile instanceof IActiveState) || ((IActiveState)tile).lightUpdate() && MekanismConfig.client.machineEffects.get()) {
            WorldUtils.recheckLighting((IBlockDisplayReader)world, pos);
        }
    }

    public static void recheckLighting(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos) {
        world.func_225524_e_().func_215568_a(pos);
    }

    public static float getSunBrightness(World world, float partialTicks) {
        float f = world.func_242415_f(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @Contract(value="null, _ -> false")
    public static boolean canSeeSun(@Nullable World world, BlockPos pos) {
        return world != null && world.func_230315_m_().func_218272_d() && world.func_175657_ab() < 4 && world.func_175710_j(pos);
    }

    public static long getChunkPosAsLong(BlockPos pos) {
        long x = pos.func_177958_n() >> 4;
        long z = pos.func_177952_p() >> 4;
        return x & 0xFFFFFFFFL | (z & 0xFFFFFFFFL) << 32;
    }

    public static BlockPos getBlockPosFromChunkPos(long chunkPos) {
        return new BlockPos((int)chunkPos, 0, (int)(chunkPos >> 32));
    }
}

