/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.compat;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RFToolsDimensionsTOPDriver
implements TOPDriver {
    public static final RFToolsDimensionsTOPDriver DRIVER = new RFToolsDimensionsTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = blockState.func_177230_c().getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (blockState.func_177230_c() == EssencesModule.BLOCK_ABSORBER.get()) {
                this.drivers.put(id, new BlockAbsorberDriver());
            } else if (blockState.func_177230_c() == EssencesModule.FLUID_ABSORBER.get()) {
                this.drivers.put(id, new FluidAbsorberDriver());
            } else if (blockState.func_177230_c() == EssencesModule.BIOME_ABSORBER.get()) {
                this.drivers.put(id, new BiomeAbsorberDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class BiomeAbsorberDriver
    implements TOPDriver {
        private BiomeAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                String biome = te.getAbsorbingBiome();
                int pct = ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
                ResourceLocation id = new ResourceLocation(biome);
                String trans = "biome." + id.func_110624_b() + "." + id.func_110623_a();
                probeInfo.text((ITextComponent)new StringTextComponent("Biome: ").func_230529_a_((ITextComponent)new TranslationTextComponent(trans)).func_240699_a_(TextFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
            }, (String)"Bad tile entity!");
        }
    }

    private static class FluidAbsorberDriver
    implements TOPDriver {
        private FluidAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                Block block = te.getAbsorbingBlock();
                if (block != null) {
                    int pct = ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
                    probeInfo.text((ITextComponent)new StringTextComponent("Fluid: ").func_230529_a_((ITextComponent)new TranslationTextComponent(block.func_149739_a())).func_240699_a_(TextFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class BlockAbsorberDriver
    implements TOPDriver {
        private BlockAbsorberDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int absorbing = te.getAbsorbing();
                Block block = te.getAbsorbingBlock();
                int pct = ((Integer)EssencesConfig.maxBlockAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBlockAbsorption.get();
                ItemStack stack = new ItemStack((IItemProvider)block, 1);
                if (!stack.func_190926_b()) {
                    probeInfo.text((ITextComponent)new StringTextComponent("Block: ").func_230529_a_((ITextComponent)new TranslationTextComponent(stack.func_77977_a())).func_240699_a_(TextFormatting.GREEN)).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%")).item(stack);
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

