/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DimensionData {
    private final ResourceLocation id;
    private final DimensionDescriptor descriptor;
    private final DimensionDescriptor randomizedDescriptor;
    private long energy;

    public DimensionData(ResourceLocation id, DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor) {
        this.id = id;
        this.descriptor = descriptor;
        this.randomizedDescriptor = randomizedDescriptor;
    }

    public DimensionData(CompoundNBT tag) {
        this.id = new ResourceLocation(tag.func_74779_i("id"));
        this.descriptor = new DimensionDescriptor();
        this.descriptor.read(tag.func_74779_i("descriptor"));
        this.energy = tag.func_74763_f("energy");
        if (tag.func_74764_b("randomized")) {
            this.randomizedDescriptor = new DimensionDescriptor();
            this.randomizedDescriptor.read(tag.func_74779_i("randomized"));
        } else {
            this.randomizedDescriptor = DimensionDescriptor.EMPTY;
        }
    }

    public void write(CompoundNBT tag) {
        tag.func_74778_a("id", this.id.toString());
        tag.func_74778_a("descriptor", this.descriptor.compact());
        tag.func_74778_a("randomized", this.randomizedDescriptor.compact());
        tag.func_74772_a("energy", this.energy);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public DimensionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DimensionDescriptor getRandomizedDescriptor() {
        return this.randomizedDescriptor;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(World overworld, long energy) {
        if (energy != this.energy) {
            long old = this.energy;
            this.energy = energy;
            if (overworld == null || (old == 0L && energy > 0L ? (overworld = DimensionId.fromResourceLocation((ResourceLocation)this.id).loadWorld(overworld)) != null : energy != 0L || (overworld = DimensionId.fromResourceLocation((ResourceLocation)this.id).loadWorld(overworld)) != null)) {
                // empty if block
            }
        }
    }
}

