/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PersistantDimensionManager
extends AbstractWorldData<PersistantDimensionManager> {
    private static final String NAME = "RFToolsDimensions";
    private final Map<ResourceLocation, DimensionData> data = new HashMap<ResourceLocation, DimensionData>();
    private final Map<DimensionDescriptor, DimensionData> dataByDescriptor = new HashMap<DimensionDescriptor, DimensionData>();

    public PersistantDimensionManager(String name) {
        super(name);
    }

    @Nonnull
    public static PersistantDimensionManager get(World world) {
        return (PersistantDimensionManager)PersistantDimensionManager.getData((World)world, () -> new PersistantDimensionManager(NAME), (String)NAME);
    }

    public DimensionData getData(ResourceLocation id) {
        return this.data.get(id);
    }

    public DimensionData getData(DimensionDescriptor descriptor) {
        return this.dataByDescriptor.get(descriptor);
    }

    public Map<ResourceLocation, DimensionData> getData() {
        return this.data;
    }

    public void register(DimensionData dd) {
        this.data.put(dd.getId(), dd);
        this.dataByDescriptor.put(dd.getDescriptor(), dd);
        this.func_76185_a();
    }

    public void forget(ResourceLocation key) {
        DimensionData dd = this.data.get(key);
        this.data.remove(key);
        if (dd != null) {
            this.dataByDescriptor.remove(dd.getDescriptor());
        }
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT tag) {
        ListNBT dimensions = tag.func_150295_c("dimensions", 10);
        this.data.clear();
        this.dataByDescriptor.clear();
        for (INBT inbt : dimensions) {
            CompoundNBT dtag = (CompoundNBT)inbt;
            DimensionData dd = new DimensionData(dtag);
            this.data.put(dd.getId(), dd);
            this.dataByDescriptor.put(dd.getDescriptor(), dd);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Map.Entry<ResourceLocation, DimensionData> entry : this.data.entrySet()) {
            CompoundNBT dtag = new CompoundNBT();
            entry.getValue().write(dtag);
            list.add((Object)dtag);
        }
        tag.func_218657_a("dimensions", (INBT)list);
        return tag;
    }
}

