/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.DimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.features.buildings.BuildingTemplate;
import mcjty.rftoolsdim.dimension.features.buildings.DimletHut;
import mcjty.rftoolsdim.dimension.features.buildings.SpawnPlatform;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public class RFTFeature
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation RFTFEATURE_ID = new ResourceLocation("rftoolsdim", "rftfeature");
    public static final ResourceLocation CONFIGURED_RFTFEATURE_ID = new ResourceLocation("rftoolsdim", "configured_rftfeature");
    public static ConfiguredFeature<?, ?> RFTFEATURE_CONFIGURED;
    private static final long[] primes;

    public static void registerConfiguredFeatures() {
        Registry registry = WorldGenRegistries.field_243653_e;
        RFTFEATURE_CONFIGURED = ((RFTFeature)Registration.RFTFEATURE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(1, 0, 1)));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)CONFIGURED_RFTFEATURE_ID, RFTFEATURE_CONFIGURED);
    }

    public RFTFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (generator instanceof BaseChunkGenerator) {
            CompiledDescriptor compiledDescriptor = ((BaseChunkGenerator)generator).getDimensionSettings().getCompiledDescriptor();
            Set<CompiledFeature> features = compiledDescriptor.getFeatures();
            if (features.stream().anyMatch(f -> f.getFeatureType().equals((Object)FeatureType.NONE))) {
                return false;
            }
            boolean generatedSomething = false;
            int primeIndex = 0;
            for (CompiledFeature feature : features) {
                if (feature.getFeatureType().getFeature().generate(reader, generator, rand, pos, feature.getBlocks(), feature.getFluids(), primes[primeIndex % primes.length])) {
                    generatedSomething = true;
                }
                ++primeIndex;
            }
            ChunkPos cp = new ChunkPos(pos);
            if (cp.field_77276_a == 0 && cp.field_77275_b == 0) {
                int floorHeight = this.getFloorHeight(reader, cp);
                DimensionManager.get().registerPlatformHeight(reader.func_201672_e().func_234923_W_().func_240901_a_(), floorHeight);
                ((SpawnPlatform)SpawnPlatform.SPAWN_PLATFORM.get()).generate(reader, new BlockPos(3, floorHeight, 3), compiledDescriptor.getBaseBlocks(), BuildingTemplate.GenerateFlag.PLAIN);
                generatedSomething = true;
            } else if ((double)rand.nextFloat() < (Double)DimensionConfig.DIMLET_HUT_CHANCE.get()) {
                ((DimletHut)DimletHut.DIMLET_HUT.get()).generate(reader, new BlockPos(cp.func_180334_c() + 4, this.getFloorHeight(reader, cp), cp.func_180333_d() + 4), compiledDescriptor.getBaseBlocks(), BuildingTemplate.GenerateFlag.FILLDOWN_IFNOTVOID);
                generatedSomething = true;
            }
            return generatedSomething;
        }
        return false;
    }

    private int getFloorHeight(ISeedReader reader, ChunkPos cp) {
        int height0 = this.getHeightAt(reader, cp, 8, 8);
        int height1 = this.getHeightAt(reader, cp, 4, 4);
        int height2 = this.getHeightAt(reader, cp, 12, 4);
        int height3 = this.getHeightAt(reader, cp, 4, 12);
        int height4 = this.getHeightAt(reader, cp, 12, 12);
        return (height0 + height1 + height2 + height3 + height4) / 5;
    }

    private int getHeightAt(ISeedReader reader, ChunkPos cp, int dx, int dz) {
        int height = reader.func_201676_a(Heightmap.Type.WORLD_SURFACE, cp.func_180334_c() + dx, cp.func_180333_d() + dz);
        if (height <= 1 || height > 250) {
            height = 65;
        }
        return height;
    }

    static {
        primes = new long[]{900157L, 981961L, 50001527L, 32667413L, 1111114993L, 65548559L, 320741L, 100002509L, 35567897L, 218021L, 2900001163L, 3399018867L};
    }
}

