/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.features.buildings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import mcjty.rftoolsdim.dimension.features.IFeature;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;

public class BuildingTemplate {
    private final Map<Character, BlockState> palette = new HashMap<Character, BlockState>();
    private final Map<Character, BiConsumer<ISeedReader, BlockPos>> paletteSpecial = new HashMap<Character, BiConsumer<ISeedReader, BlockPos>>();
    private final List<Slice> slices = new ArrayList<Slice>();

    public void addPalette(Character key, BlockState state) {
        this.palette.put(key, state);
    }

    public void addPalette(Character key, BiConsumer<ISeedReader, BlockPos> consumer) {
        this.paletteSpecial.put(key, consumer);
    }

    public void generate(ISeedReader reader, BlockPos pos, List<BlockState> states, GenerateFlag flag) {
        switch (flag) {
            case PLAIN: {
                break;
            }
            case FILLDOWN: {
                this.fillDown(reader, pos, states);
                break;
            }
            case FILLDOWN_IFNOTVOID: {
                this.fillDownIfNotVoid(reader, pos, states);
            }
        }
        int y = pos.func_177956_o();
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        for (Slice slice : this.slices) {
            int z = pos.func_177952_p();
            for (String row : slice.rows) {
                for (int x = 0; x < row.length(); ++x) {
                    mpos.func_181079_c(pos.func_177958_n() + x, y, z);
                    char key = row.charAt(x);
                    if (this.paletteSpecial.containsKey(Character.valueOf(key))) {
                        this.paletteSpecial.get(Character.valueOf(key)).accept(reader, (BlockPos)mpos);
                        continue;
                    }
                    reader.func_180501_a((BlockPos)mpos, this.palette.get(Character.valueOf(key)), 0);
                }
                ++z;
            }
            ++y;
        }
    }

    private void fillDown(ISeedReader reader, BlockPos pos, List<BlockState> states) {
        int y = pos.func_177956_o();
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        Slice slice = this.slices.get(0);
        int z = pos.func_177952_p();
        for (String row : slice.rows) {
            block1: for (int x = 0; x < row.length(); ++x) {
                for (int yy = y - 1; yy > 1; --yy) {
                    mpos.func_181079_c(pos.func_177958_n() + x, yy, z);
                    BlockState state = reader.func_180495_p((BlockPos)mpos);
                    if (!state.func_177230_c().isAir(state, (IBlockReader)reader, (BlockPos)mpos)) continue block1;
                    BlockState blockState = IFeature.select(states, reader.func_201674_k());
                    reader.func_180501_a((BlockPos)mpos, blockState, 0);
                }
            }
            ++z;
        }
    }

    private void fillDownIfNotVoid(ISeedReader reader, BlockPos pos, List<BlockState> states) {
        int y = pos.func_177956_o();
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        Slice slice = this.slices.get(0);
        int z = pos.func_177952_p();
        for (String row : slice.rows) {
            block1: for (int x = 0; x < row.length(); ++x) {
                BlockState state;
                int yy;
                boolean isVoid = true;
                for (yy = y - 1; yy > 1; --yy) {
                    mpos.func_181079_c(pos.func_177958_n() + x, yy, z);
                    state = reader.func_180495_p((BlockPos)mpos);
                    if (state.func_177230_c().isAir(state, (IBlockReader)reader, (BlockPos)mpos)) continue;
                    isVoid = false;
                    break;
                }
                if (isVoid) continue;
                for (yy = y - 1; yy > 1; --yy) {
                    mpos.func_181079_c(pos.func_177958_n() + x, yy, z);
                    state = reader.func_180495_p((BlockPos)mpos);
                    if (!state.func_177230_c().isAir(state, (IBlockReader)reader, (BlockPos)mpos)) continue block1;
                    BlockState blockState = IFeature.select(states, reader.func_201674_k());
                    reader.func_180501_a((BlockPos)mpos, blockState, 0);
                }
            }
            ++z;
        }
    }

    public Slice slice() {
        Slice slice = new Slice();
        this.slices.add(slice);
        return slice;
    }

    public static class Slice {
        private final List<String> rows = new ArrayList<String>();

        public Slice row(String r) {
            this.rows.add(r);
            return this;
        }
    }

    public static enum GenerateFlag {
        PLAIN,
        FILLDOWN,
        FILLDOWN_IFNOTVOID;

    }
}

