/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionManager;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.network.PackagePropageDataToClients;
import mcjty.rftoolsdim.dimension.power.DamageSourcePowerLow;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class PowerHandler {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;

    public static long calculateMaxDimensionPower(ResourceLocation id, World overworld) {
        CompiledDescriptor descriptor = DimensionManager.get().getCompiledDescriptor(overworld, id);
        if (descriptor != null) {
            return PowerHandler.calculateMaxDimensionPower(descriptor);
        }
        return (Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get();
    }

    public static long calculateMaxDimensionPower(CompiledDescriptor descriptor) {
        int cost = descriptor.getActualPowerCost();
        if (cost <= (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get()) {
            return (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get();
        }
        if (cost >= (Integer)DimensionConfig.MAX_POWER_THRESSHOLD.get()) {
            return (Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get();
        }
        long power = (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get() + (long)(cost - (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get()) * ((Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get() - (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get()) / (long)((Integer)DimensionConfig.MAX_POWER_THRESSHOLD.get() - (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get());
        power /= ((Long)DimensionConfig.POWER_MULTIPLES.get()).longValue();
        return power *= ((Long)DimensionConfig.POWER_MULTIPLES.get()).longValue();
    }

    public void handlePower(World overworld) {
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.handlePower(overworld, doEffects);
            this.sendOutPower(overworld);
        }
    }

    private void sendOutPower(World overworld) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(overworld);
        HashMap<ResourceLocation, ClientDimensionData.Power> powerMap = new HashMap<ResourceLocation, ClientDimensionData.Power>();
        for (Map.Entry<ResourceLocation, DimensionData> entry : mgr.getData().entrySet()) {
            long energy = entry.getValue().getEnergy();
            powerMap.put(entry.getKey(), new ClientDimensionData.Power(energy, PowerHandler.calculateMaxDimensionPower(entry.getKey(), (World)((ServerWorld)overworld))));
        }
        RFToolsDimMessages.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PackagePropageDataToClients(powerMap, ((ServerWorld)overworld).func_72905_C()));
    }

    private void handlePower(World overworld, boolean doEffects) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(overworld);
        for (Map.Entry<ResourceLocation, DimensionData> entry : mgr.getData().entrySet()) {
            ServerWorld world = DimensionId.fromResourceLocation((ResourceLocation)entry.getKey()).loadWorld(overworld);
            CompiledDescriptor compiledDescriptor = DimensionManager.get().getCompiledDescriptor((World)world);
            if (compiledDescriptor == null) continue;
            long power = this.handlePowerDimension(doEffects, world, entry.getValue(), compiledDescriptor);
            if (doEffects && power > 0L) {
                this.handleEffectsForDimension(power, world, compiledDescriptor);
            }
            if (world == null || world.func_217369_A().isEmpty()) continue;
            this.handleRandomEffects(world, entry.getValue());
        }
        mgr.save();
    }

    private long handlePowerDimension(boolean doEffects, ServerWorld world, DimensionData data, CompiledDescriptor compiledDescriptor) {
        int cost = compiledDescriptor.getActualPowerCost();
        long power = data.getEnergy();
        if ((power -= (long)(cost * 10)) < 0L) {
            power = 0L;
        }
        this.handleLowPower(world, power, doEffects, cost);
        data.setEnergy((World)world, power);
        return power;
    }

    private void handleEffectsForDimension(long power, ServerWorld world, CompiledDescriptor compiledDescriptor) {
        if (world != null) {
            ArrayList players = new ArrayList(world.func_217369_A());
            for (ServerPlayerEntity player : players) {
                long max = PowerHandler.calculateMaxDimensionPower(compiledDescriptor);
                int percentage = (int)(power * 100L / max);
                if (percentage < (Integer)DimensionConfig.DIMPOWER_WARN3.get()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, 360, 4, true, true));
                    player.func_195064_c(new EffectInstance(Effects.field_76419_f, 360, 4, true, true));
                    player.func_195064_c(new EffectInstance(Effects.field_76436_u, 360, 2, true, true));
                    player.func_195064_c(new EffectInstance(Effects.field_76438_s, 360, 2, true, true));
                    continue;
                }
                if (percentage < (Integer)DimensionConfig.DIMPOWER_WARN2.get()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, 360, 2, true, true));
                    player.func_195064_c(new EffectInstance(Effects.field_76419_f, 360, 2, true, true));
                    player.func_195064_c(new EffectInstance(Effects.field_76438_s, 360, 1, true, true));
                    continue;
                }
                if (percentage >= (Integer)DimensionConfig.DIMPOWER_WARN1.get()) continue;
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 360, 0, true, true));
                player.func_195064_c(new EffectInstance(Effects.field_76419_f, 360, 0, true, true));
            }
        }
    }

    private void handleLowPower(ServerWorld world, long power, boolean doEffects, int phasedCost) {
        if (power <= 0L && world != null) {
            ArrayList players = new ArrayList(world.func_217369_A());
            for (PlayerEntity player : players) {
                if (!PhasedFieldGenerator.checkValidPhasedFieldGenerator(player, true, phasedCost)) {
                    player.func_70097_a((DamageSource)new DamageSourcePowerLow("powerLow"), 1000000.0f);
                    continue;
                }
                if (!doEffects || !((Boolean)DimensionConfig.PHASED_FIELD_GENERATOR_DEBUF.get()).booleanValue()) continue;
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 180, 2, true, true));
                player.func_195064_c(new EffectInstance(Effects.field_76419_f, 180, 2, true, true));
                player.func_195064_c(new EffectInstance(Effects.field_76438_s, 180, 2, true, true));
            }
        }
    }

    private void handleRandomEffects(ServerWorld world, DimensionData information) {
    }
}

