/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import mcjty.rftoolsdim.dimension.biomes.RFTBiomeProvider;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public abstract class BaseChunkGenerator
extends ChunkGenerator {
    protected final DimensionSettings field_222543_d;
    protected INoiseGenerator surfaceDepthNoise;
    protected final SharedSeedRandom randomSeed;
    protected final List<BlockState> defaultBlocks = new ArrayList<BlockState>();
    private BlockState defaultFluid;

    public BaseChunkGenerator(Registry<Biome> registry, DimensionSettings settings) {
        super((BiomeProvider)new RFTBiomeProvider(registry, settings), new DimensionStructuresSettings(false));
        this.field_222543_d = settings;
        this.randomSeed = new SharedSeedRandom(settings.getSeed());
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-3, 0));
        this.defaultBlocks.addAll(settings.getCompiledDescriptor().getBaseBlocks());
        this.defaultFluid = settings.getCompiledDescriptor().getBaseLiquid();
        if (settings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.NOOCEANS)) {
            this.defaultFluid = Blocks.field_150350_a.func_176223_P();
        }
    }

    public BlockState getDefaultBlock() {
        if (this.defaultBlocks.size() == 1) {
            return this.defaultBlocks.get(0);
        }
        int idx = this.randomSeed.nextInt(this.defaultBlocks.size());
        return this.defaultBlocks.get(idx);
    }

    public DimensionSettings getDimensionSettings() {
        return this.field_222543_d;
    }

    public Registry<Biome> getBiomeRegistry() {
        return ((RFTBiomeProvider)this.field_222542_c).getBiomeRegistry();
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        if (this.field_222543_d.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.NOBIOMESURFACE)) {
            this.makeBedrock(chunk);
            return;
        }
        ChunkPos chunkpos = chunk.func_76632_l();
        int cx = chunkpos.field_77276_a;
        int cz = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(cx, cz);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int xStart = chunkpos1.func_180334_c();
        int zStart = chunkpos1.func_180333_d();
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xx = xStart + x;
                int zz = zStart + z;
                int yy = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z) + 1;
                double noise = this.surfaceDepthNoise.func_215460_a((double)xx * 0.0625, (double)zz * 0.0625, 0.0625, (double)x * 0.0625) * 15.0;
                region.func_226691_t_((BlockPos)mpos.func_181079_c(xStart + x, yy, zStart + z)).func_206854_a((Random)sharedseedrandom, chunk, xx, zz, yy, noise, this.defaultBlocks.get(0), this.getBaseLiquid(), this.func_230356_f_(), region.func_72905_C());
            }
        }
        this.makeBedrock(chunk);
    }

    protected BlockState getBaseLiquid() {
        return this.defaultFluid;
    }

    protected void makeBedrock(IChunk chunkIn) {
        if (this.field_222543_d.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.NOBEDROCK)) {
            return;
        }
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        int xs = chunkIn.func_76632_l().func_180334_c();
        int zs = chunkIn.func_76632_l().func_180333_d();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)xs, (int)0, (int)zs, (int)(xs + 15), (int)0, (int)(zs + 15))) {
            for (int y = 4; y >= 0; --y) {
                if (y > this.randomSeed.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)mpos.func_181079_c(blockpos.func_177958_n(), y, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }
}

