/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.client;

import mcjty.lib.McJtyLib;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.DimensionMonitorItem;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ClientHelpers {
    public static String getDimensionName(ItemStack stack) {
        World world = McJtyLib.proxy.getClientWorld();
        if (world == null) {
            return "";
        }
        return world.func_234923_W_().func_240901_a_().func_110623_a();
    }

    public static String getPowerString(ItemStack s) {
        World world = McJtyLib.proxy.getClientWorld();
        if (world == null) {
            return "";
        }
        ResourceLocation id = world.func_234923_W_().func_240901_a_();
        long power = ClientDimensionData.get().getPower(id);
        long max = ClientDimensionData.get().getMaxPower(id);
        return power == -1L ? "<n.a.>" : "" + power + " (" + max + ")";
    }

    public static void initOverrides(DimensionMonitorItem item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("rftoolsdim", "power"), (stack, world, livingEntity) -> {
            ClientWorld w = world;
            if (w == null) {
                if (livingEntity == null) {
                    return 0.0f;
                }
                w = livingEntity.func_130014_f_();
            }
            ResourceLocation id = w.func_234923_W_().func_240901_a_();
            long power = ClientDimensionData.get().getPower(id);
            long max = ClientDimensionData.get().getMaxPower(id);
            if (max < 0L) {
                return 8.0f;
            }
            long level = 9L * power / max;
            if (level < 0L) {
                level = 0L;
            } else if (level > 8L) {
                level = 9L;
            }
            return 8L - level;
        });
    }

    public static void initOverrides(PhasedFieldGenerator item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("rftoolsdim", "power"), (stack, world, livingEntity) -> {
            long max;
            long level;
            long power = 0L;
            if (stack.func_77942_o()) {
                power = stack.func_77978_p().func_74763_f("Energy");
            }
            if ((level = 9L * power / (max = ((Long)DimensionBuilderConfig.PHASEDFIELD_MAXENERGY.get()).longValue())) < 0L) {
                level = 0L;
            } else if (level > 8L) {
                level = 9L;
            }
            return 8L - level;
        });
    }
}

