/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;

public class PhasedFieldGenerator
extends Item
implements IEnergyItem,
ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"power", this::getEnergyString)});

    private String getEnergyString(ItemStack stack) {
        return Integer.toString(stack.func_77942_o() ? stack.func_77978_p().func_74762_e("Energy") : 0);
    }

    public PhasedFieldGenerator() {
        super(new Item.Properties().func_200916_a(RFToolsDim.setup.getTab()).func_200917_a(1));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_190926_b() != newStack.func_190926_b()) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), stack, list, flagIn);
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        CompoundNBT tag = container.func_196082_o();
        long energy = tag.func_74763_f("Energy");
        long energyReceived = Math.min(this.getMaxEnergyStoredL(container) - energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_RECEIVEPERTICK.get(), maxReceive));
        if (!simulate) {
            tag.func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        CompoundNBT tag = container.func_196082_o();
        long energy = tag.func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get() * 10L, maxExtract));
        if (!simulate) {
            tag.func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        return container.func_77978_p().func_74763_f("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return (Long)DimensionBuilderConfig.PHASEDFIELD_MAXENERGY.get();
    }

    public static boolean checkValidPhasedFieldGenerator(PlayerEntity player, boolean consume, int tickCost) {
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            int toConsume;
            PhasedFieldGenerator pfg;
            int energyStored;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot.func_190926_b() || slot.func_77973_b() != DimensionBuilderModule.PHASED_FIELD_GENERATOR.get() || (energyStored = (pfg = (PhasedFieldGenerator)slot.func_77973_b()).getEnergyStored(slot)) < (toConsume = (Boolean)DimensionConfig.ENABLE_DYNAMIC_PHASECOST.get() != false ? (int)((double)(10 * tickCost) * (Double)DimensionConfig.DYNAMIC_PHASECOST_AMOUNT.get()) : (int)(10L * (Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get()))) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }
}

