/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;

public class RealizedDimensionTab
extends Item {
    public RealizedDimensionTab() {
        super(new Item.Properties().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_225608_bj_()) {
            CompoundNBT tagCompound = stack.func_77978_p();
            Logging.message((PlayerEntity)player, (String)tagCompound.func_74779_i("descriptor"));
            if (tagCompound.func_74764_b("dimension")) {
                String dimension = tagCompound.func_74779_i("dimension");
                DimensionData data = PersistantDimensionManager.get(world).getData(new ResourceLocation(dimension));
                if (data != null) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Energy: " + TextFormatting.WHITE + data.getEnergy()), false);
                    DimensionDescriptor descriptor = data.getDescriptor();
                    descriptor.dump(player);
                    player.func_146105_b((ITextComponent)new StringTextComponent("-----------------------------"), false);
                    DimensionDescriptor randomized = data.getRandomizedDescriptor();
                    randomized.dump(player);
                }
                DimensionId id = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dimension));
                ServerWorld serverWorld = id.getWorld();
                ChunkGenerator generator = serverWorld.func_72863_F().field_186029_c;
                if (generator instanceof BaseChunkGenerator) {
                    DimensionSettings settings = ((BaseChunkGenerator)generator).getDimensionSettings();
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Seed: " + TextFormatting.WHITE + settings.getSeed()), false);
                }
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            ResourceLocation dimension;
            ResourceLocation resourceLocation = dimension = tagCompound.func_74764_b("dimension") ? new ResourceLocation(tagCompound.func_74779_i("dimension")) : null;
            if (dimension != null) {
                list.add((ITextComponent)new StringTextComponent("Name: " + dimension.func_110623_a()).func_240699_a_(TextFormatting.BLUE));
            } else if (tagCompound.func_74764_b("name")) {
                String name = tagCompound.func_74779_i("name");
                list.add((ITextComponent)new StringTextComponent("Name: " + name).func_240699_a_(TextFormatting.BLUE));
            }
            if (McJtyLib.proxy.isSneaking()) {
                String descriptionString = tagCompound.func_74779_i("descriptor");
                String randomizedString = tagCompound.func_74779_i("randomized");
                this.constructDescriptionHelp(list, descriptionString, randomizedString);
            } else {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "    <Press Shift>"));
            }
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            if (ticksLeft == 0) {
                long power = ClientDimensionData.get().getPower(dimension);
                long max = ClientDimensionData.get().getMaxPower(dimension);
                list.add((ITextComponent)new StringTextComponent("Dimension ready!").func_240699_a_(TextFormatting.BLUE));
                int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick"));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "    Current power: " + power + " (" + max + ")"));
            } else {
                int createCost = tagCompound.func_74762_e("rfCreateCost");
                int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                int tickCost = tagCompound.func_74762_e("tickCost");
                int percentage = 0;
                if (tickCost != 0) {
                    percentage = (tickCost - ticksLeft) * 100 / tickCost;
                }
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Dimension progress: " + percentage + "%"));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "    Creation cost: " + createCost + " RF/tick"));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick"));
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "    Tick cost: " + tickCost + " ticks"));
            }
        }
    }

    private void constructDescriptionHelp(List<ITextComponent> list, String descriptionString, String randomizedString) {
        CompiledDescriptor compiledDescriptor;
        DescriptorError error;
        DimensionDescriptor descriptor = new DimensionDescriptor();
        descriptor.read(descriptionString);
        DimensionDescriptor randomizedDescriptor = new DimensionDescriptor();
        if (!randomizedString.isEmpty()) {
            randomizedDescriptor.read(randomizedString);
        }
        if ((error = (compiledDescriptor = new CompiledDescriptor()).compile(descriptor, randomizedDescriptor)).isOk()) {
            if (compiledDescriptor.getTerrainType() != null) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "    Terrain: " + TextFormatting.WHITE + compiledDescriptor.getTerrainType().getName()));
            }
            if (compiledDescriptor.getBiomeControllerType() != null) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "    Biome Controller: " + TextFormatting.WHITE + compiledDescriptor.getBiomeControllerType().getName()));
            }
            if (compiledDescriptor.getTimeType() != null) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "    Time: " + TextFormatting.WHITE + compiledDescriptor.getTimeType().getName()));
            }
            for (CompiledFeature feature : compiledDescriptor.getFeatures()) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "    Feature: " + TextFormatting.WHITE + feature.getFeatureType().getName()));
            }
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Parse error: " + error.getMessage()));
        }
    }
}

