/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.tuple.Pair;

public class DimletItem
extends Item
implements ITooltipSettings,
ITooltipExtras {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage"), TooltipBuilder.parameter((String)"key", DimletItem::isReadyDimlet, DimletTools::getDimletDescription)}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"key", DimletItem::isReadyDimlet, DimletTools::getDimletDescription), TooltipBuilder.parameter((String)"rarity", DimletItem::isReadyDimlet, DimletTools::getDimletRarity), TooltipBuilder.parameter((String)"cost", DimletItem::isReadyDimlet, DimletTools::getDimletCost)});
    private final DimletType type;
    private final boolean isReady;

    public DimletItem(DimletType type, boolean isReady) {
        super(Registration.createStandardProperties());
        this.type = type;
        this.isReady = isReady;
    }

    public static boolean isReadyDimlet(ItemStack stack) {
        Item item = stack.func_77973_b();
        return DimletItem.isReadyDimlet(item);
    }

    private static boolean isReadyDimlet(Item item) {
        if (item instanceof DimletItem) {
            return ((DimletItem)item).isReady;
        }
        return false;
    }

    public static boolean isEmptyDimlet(ItemStack stack) {
        if (stack.func_77973_b() instanceof DimletItem) {
            if (stack.func_77973_b() == DimletModule.EMPTY_DIMLET.get()) {
                return false;
            }
            return !((DimletItem)stack.func_77973_b()).isReady;
        }
        return false;
    }

    public DimletType getType() {
        return this.type;
    }

    public static DimletType getType(ItemStack stack) {
        if (stack.func_77973_b() instanceof DimletItem) {
            return ((DimletItem)stack.func_77973_b()).getType();
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (this == DimletModule.ADMIN_DIMLET.get()) {
                ItemStack stack = DimletTools.getDimletStack(new DimletKey(DimletType.ADMIN, "owner"));
                if (!stack.func_190926_b()) {
                    items.add((Object)stack);
                }
                if (!(stack = DimletTools.getDimletStack(new DimletKey(DimletType.ADMIN, "cheater"))).func_190926_b()) {
                    items.add((Object)stack);
                }
            } else if (this == DimletModule.DIGIT_DIMLET.get()) {
                for (int i = 0; i < 10; ++i) {
                    items.add((Object)DimletTools.getDimletStack(new DimletKey(DimletType.DIGIT, "" + i)));
                }
            } else {
                items.add((Object)new ItemStack((IItemProvider)this));
            }
        }
    }

    public List<Pair<ItemStack, Integer>> getItems(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key != null) {
            ItemStack essence;
            DimletSettings settings;
            ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
            items.add(Pair.of((Object)DimletTools.getNeededEnergyPart(key), (Object)-2));
            items.add(Pair.of((Object)DimletTools.getNeededMemoryPart(key), (Object)-2));
            long seed = ClientDimensionData.get().getWorldSeed();
            if (seed != -1L) {
                DimletPattern pattern = KnowledgeManager.get().getPattern(seed, key);
                DimletItem.addPatternItems(pattern, items);
            }
            if ((settings = DimletDictionary.get().getSettings(key)) != null && !(essence = DimletTools.getNeededEssence(key, settings)).func_190926_b()) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)essence, (Object)-1));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public static void addPatternItems(DimletPattern pattern, List<Pair<ItemStack, Integer>> items) {
        if (pattern != null) {
            int cnt = pattern.count('*');
            if (cnt > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((IItemProvider)Registration.DIMENSIONAL_SHARD, cnt), (Object)-1));
            }
            if ((cnt = pattern.count('0')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((IItemProvider)DimletModule.COMMON_ESSENCE.get(), cnt), (Object)-1));
            }
            if ((cnt = pattern.count('1')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((IItemProvider)DimletModule.RARE_ESSENCE.get(), cnt), (Object)-1));
            }
            if ((cnt = pattern.count('2')) > 0) {
                items.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack((IItemProvider)DimletModule.LEGENDARY_ESSENCE.get(), cnt), (Object)-1));
            }
        }
    }
}

