/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;

public class LootTableCondition
implements ILootCondition {
    private final Set<ResourceLocation> tables;

    public LootTableCondition(Set<ResourceLocation> tables) {
        this.tables = tables;
    }

    public LootConditionType func_230419_b_() {
        return DimletModule.LOOT_TABLE_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation table = lootContext.getQueriedLootTableId();
        return this.tables.contains(table);
    }

    public static class Serializer
    implements ILootSerializer<LootTableCondition> {
        public void serialize(JsonObject object, LootTableCondition condition, JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            for (ResourceLocation table : condition.tables) {
                array.add(table.toString());
            }
            object.add("tables", (JsonElement)array);
        }

        public LootTableCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            HashSet<ResourceLocation> tables = new HashSet<ResourceLocation>();
            JsonArray tablesArray = object.getAsJsonArray("tables");
            tables.clear();
            for (JsonElement element : tablesArray) {
                tables.add(new ResourceLocation(element.getAsString()));
            }
            return new LootTableCondition(tables);
        }
    }
}

