/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.modules.dimlets.client.DimletClientHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendDimletsToClient {
    private final BlockPos pos;
    private final List<DimletClientHelper.DimletWithInfo> dimlets;

    public PacketSendDimletsToClient(BlockPos pos, List<DimletClientHelper.DimletWithInfo> dimlets) {
        this.pos = pos;
        this.dimlets = new ArrayList<DimletClientHelper.DimletWithInfo>(dimlets);
    }

    public PacketSendDimletsToClient(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        int size = buf.readInt();
        this.dimlets = new ArrayList<DimletClientHelper.DimletWithInfo>(size);
        for (int i = 0; i < size; ++i) {
            short idx = buf.readShort();
            DimletType type = DimletType.values()[idx];
            String key = buf.func_150789_c(Short.MAX_VALUE);
            DimletKey dimlet = new DimletKey(type, key);
            boolean craftable = buf.readBoolean();
            this.dimlets.add(new DimletClientHelper.DimletWithInfo(dimlet, craftable));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.dimlets.size());
        for (DimletClientHelper.DimletWithInfo key : this.dimlets) {
            DimletKey dimlet = key.getDimlet();
            buf.writeShort(dimlet.getType().ordinal());
            buf.func_180714_a(dimlet.getKey());
            buf.writeBoolean(key.isCraftable());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            IClientCommandHandler clientCommandHandler;
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof IClientCommandHandler && !(clientCommandHandler = (IClientCommandHandler)te).receiveListFromServer("workbench.getdimlets", this.dimlets, Type.create(DimletClientHelper.DimletWithInfo.class))) {
                Logging.log((String)"Command workbench.getdimlets was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

