/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimletCycleRecipeBuilder
implements IRecipeBuilder<DimletCycleRecipeBuilder> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private String input;
    private String output;

    public DimletCycleRecipeBuilder(IItemProvider resultIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public static DimletCycleRecipeBuilder shapedRecipe(IItemProvider resultIn) {
        return DimletCycleRecipeBuilder.shapedRecipe(resultIn, 1);
    }

    public static DimletCycleRecipeBuilder shapedRecipe(IItemProvider resultIn, int countIn) {
        return new DimletCycleRecipeBuilder(resultIn, countIn);
    }

    public DimletCycleRecipeBuilder define(Character symbol, ITag<Item> tagIn) {
        return this.define(symbol, Ingredient.func_199805_a(tagIn));
    }

    public DimletCycleRecipeBuilder input(String input) {
        this.input = input;
        return this;
    }

    public DimletCycleRecipeBuilder output(String output) {
        this.output = output;
        return this;
    }

    public DimletCycleRecipeBuilder define(Character symbol, IItemProvider itemIn) {
        return this.define(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public DimletCycleRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public DimletCycleRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public DimletCycleRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public DimletCycleRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.key, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a()), this.input, this.output));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final String input;
        private final String output;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<String> patternIn, Map<Character, Ingredient> keyIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn, String input, String output) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.pattern = patternIn;
            this.key = keyIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
            this.input = input;
            this.output = output;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("input", this.input);
            json.addProperty("output", this.output);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)DimletModule.DIMLET_CYCLE_SERIALIZER.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

