/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.knowledge.data.CommonTags;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import mcjty.rftoolsdim.modules.knowledge.data.RandomPatternCreator;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class KnowledgeManager {
    private long worldSeed = -1L;
    private Map<KnowledgeKey, DimletPattern> patterns = null;
    private final Map<DimletRarity, List<KnowledgeKey>> knownPatterns = new HashMap<DimletRarity, List<KnowledgeKey>>();
    private final Map<KnowledgeKey, String> keyReasons = new HashMap<KnowledgeKey, String>();
    private static final KnowledgeManager INSTANCE = new KnowledgeManager();
    private final CommonTags commonTags = new CommonTags();

    public static KnowledgeManager get() {
        return INSTANCE;
    }

    public void clear() {
        this.commonTags.clear();
        this.keyReasons.clear();
        this.knownPatterns.clear();
        this.patterns = null;
        this.worldSeed = -1L;
    }

    private void resolve(long seed) {
        if (seed != this.worldSeed || this.patterns == null) {
            this.worldSeed = seed;
            this.patterns = RandomPatternCreator.createRandomPatterns(seed);
        }
    }

    public static ItemStack getPatternItem(char p) {
        switch (p) {
            case ' ': {
                return ItemStack.field_190927_a;
            }
            case '*': {
                return new ItemStack((IItemProvider)Registration.DIMENSIONAL_SHARD);
            }
            case '0': {
                return new ItemStack((IItemProvider)DimletModule.COMMON_ESSENCE.get());
            }
            case '1': {
                return new ItemStack((IItemProvider)DimletModule.RARE_ESSENCE.get());
            }
            case '2': {
                return new ItemStack((IItemProvider)DimletModule.LEGENDARY_ESSENCE.get());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static char getPatternChar(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ' ';
        }
        Item item = stack.func_77973_b();
        if (item == Registration.DIMENSIONAL_SHARD) {
            return '*';
        }
        if (item == DimletModule.COMMON_ESSENCE.get()) {
            return '0';
        }
        if (item == DimletModule.RARE_ESSENCE.get()) {
            return '1';
        }
        if (item == DimletModule.LEGENDARY_ESSENCE.get()) {
            return '2';
        }
        return ' ';
    }

    @Nullable
    private String getKnowledgeSetReason(DimletKey key) {
        switch (key.getType()) {
            case TERRAIN: {
                return null;
            }
            case ATTRIBUTE: {
                return null;
            }
            case BIOME_CONTROLLER: {
                return null;
            }
            case BIOME: {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(key.getKey()));
                if (biome != null) {
                    return biome.func_201856_r().func_222352_a() + " biomes";
                }
                return null;
            }
            case FEATURE: {
                return null;
            }
            case TIME: {
                return null;
            }
            case ADMIN: {
                return null;
            }
            case BLOCK: {
                ResourceLocation tagId = this.getMostCommonTagForBlock(key);
                if (tagId != null) {
                    return tagId.func_110623_a();
                }
                return null;
            }
            case FLUID: {
                return new ResourceLocation(key.getKey()).func_110624_b();
            }
        }
        return null;
    }

    private KnowledgeSet getKnowledgeSet(DimletKey key) {
        switch (key.getType()) {
            case TERRAIN: {
                return TerrainType.byName(key.getKey()).getSet();
            }
            case ATTRIBUTE: {
                return AttributeType.byName(key.getKey()).getSet();
            }
            case BIOME_CONTROLLER: {
                return BiomeControllerType.byName(key.getKey()).getSet();
            }
            case BIOME: {
                return this.getBiomeKnowledgeSet(key);
            }
            case FEATURE: {
                return FeatureType.byName(key.getKey()).getSet();
            }
            case TIME: {
                return TimeType.byName(key.getKey()).getSet();
            }
            case BLOCK: {
                return this.getBlockKnowledgeSet(key);
            }
            case FLUID: {
                return this.getFluidKnowledgeSet(key);
            }
            case DIGIT: {
                break;
            }
        }
        return KnowledgeSet.SET1;
    }

    private KnowledgeSet getFluidKnowledgeSet(DimletKey key) {
        int i = Math.abs(new ResourceLocation(key.getKey()).func_110624_b().hashCode());
        return KnowledgeSet.values()[i % KnowledgeSet.values().length];
    }

    private KnowledgeSet getBlockKnowledgeSet(DimletKey key) {
        ResourceLocation tagId = this.getMostCommonTagForBlock(key);
        if (tagId == null) {
            return KnowledgeSet.SET1;
        }
        int i = Math.abs(tagId.hashCode());
        return KnowledgeSet.values()[i % KnowledgeSet.values().length];
    }

    private ResourceLocation getMostCommonTagForBlock(DimletKey key) {
        ResourceLocation mostImportant = null;
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.getKey()));
        if (block == null) {
            RFToolsDim.setup.getLogger().error("Block '" + key.getKey() + "' is missing!");
        } else {
            Set tags = block.getTags();
            int maxAmount = -1;
            for (ResourceLocation tag : tags) {
                List elements = BlockTags.createOptional((ResourceLocation)tag).func_230236_b_();
                int size = elements.size();
                if (this.commonTags.isCommon(tag)) {
                    size += 10;
                }
                if (size <= maxAmount) continue;
                mostImportant = tag;
                maxAmount = size;
            }
        }
        return mostImportant;
    }

    private KnowledgeSet getBiomeKnowledgeSet(DimletKey key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(key.getKey()));
        if (biome == null) {
            RFToolsDim.setup.getLogger().error("Biome '" + key.getKey() + "' is missing!");
            return KnowledgeSet.SET1;
        }
        return KnowledgeSet.values()[biome.func_201856_r().ordinal() % KnowledgeSet.values().length];
    }

    @Nullable
    public KnowledgeKey getKnowledgeKey(long seed, DimletKey key) {
        this.resolve(seed);
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return null;
        }
        KnowledgeSet set = this.getKnowledgeSet(key);
        return new KnowledgeKey(key.getType(), settings.getRarity(), set);
    }

    @Nullable
    public DimletPattern getPattern(long seed, DimletKey key) {
        KnowledgeKey kkey = this.getKnowledgeKey(seed, key);
        if (kkey == null) {
            return null;
        }
        return this.patterns.get(kkey);
    }

    public String getReason(World world, KnowledgeKey key) {
        this.getKnownPatterns(world, key.getRarity());
        return this.keyReasons.get(key);
    }

    public List<KnowledgeKey> getKnownPatterns(World world, DimletRarity rarity) {
        if (!this.knownPatterns.containsKey((Object)rarity)) {
            ArrayList<KnowledgeKey> set = new ArrayList<KnowledgeKey>();
            for (DimletKey key : DimletDictionary.get().getDimlets()) {
                KnowledgeKey kkey;
                DimletSettings settings = DimletDictionary.get().getSettings(key);
                if (settings == null || !Objects.equals((Object)settings.getRarity(), (Object)rarity) || (kkey = this.getKnowledgeKey(DimensionId.overworld().loadWorld(world).func_72905_C(), key)) == null) continue;
                set.add(kkey);
                String reason = this.getKnowledgeSetReason(key);
                if (reason == null) continue;
                this.keyReasons.put(kkey, reason);
            }
            RFToolsDim.setup.getLogger().info("Patterns for rarity " + rarity.name() + ": " + set.size());
            this.knownPatterns.put(rarity, set);
        }
        return this.knownPatterns.get((Object)rarity);
    }
}

